/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.mvn;

import io.fabric8.agent.mvn.Version;
import io.fabric8.common.util.NullArgumentException;
import io.fabric8.common.util.URLUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class DownloadableArtifact {
    private final Version m_version;
    private final int m_priority;
    private final URL m_artifactURL;
    private final Boolean m_checkCertificate;
    private final boolean m_localSnapshotBuild;

    public DownloadableArtifact(String version, int priority, URL repositoryURL, String path, boolean localSnapshotBuild, Boolean checkCertificate) throws IOException {
        this.m_priority = priority;
        NullArgumentException.validateNotEmpty((String)version, (String)"Version");
        NullArgumentException.validateNotNull((Object)repositoryURL, (String)"Repository URL");
        NullArgumentException.validateNotNull((Object)path, (String)"Path");
        NullArgumentException.validateNotNull((Object)localSnapshotBuild, (String)"Local snapshot build");
        NullArgumentException.validateNotNull((Object)checkCertificate, (String)"Certificate check");
        this.m_version = new Version(version);
        String repository = repositoryURL.toExternalForm();
        if (!repository.endsWith("/")) {
            repository = repository + "/";
        }
        this.m_artifactURL = new URL(repository + path);
        this.m_localSnapshotBuild = localSnapshotBuild;
        this.m_checkCertificate = checkCertificate;
    }

    public InputStream getInputStream() throws IOException {
        return URLUtils.prepareInputStream((URL)this.m_artifactURL, (this.m_checkCertificate == false ? 1 : 0) != 0);
    }

    public Version getVersion() {
        return this.m_version;
    }

    public int getPriority() {
        return this.m_priority;
    }

    public URL getArtifactURL() {
        return this.m_artifactURL;
    }

    public boolean isLocalSnapshotBuild() {
        return this.m_localSnapshotBuild;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.m_version.equals(((DownloadableArtifact)o).m_version);
    }

    public int hashCode() {
        return this.m_version.hashCode();
    }

    public String toString() {
        return "Version [" + this.m_version + "]" + " from URL [" + this.m_artifactURL + "]";
    }
}

