/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dmr;

public enum ModelType {
    BIG_DECIMAL('d'),
    BIG_INTEGER('i'),
    BOOLEAN('Z'),
    BYTES('b'),
    DOUBLE('D'),
    EXPRESSION('e'),
    INT('I'),
    LIST('l'),
    LONG('J'),
    OBJECT('o'),
    PROPERTY('p'),
    STRING('s'),
    TYPE('t'),
    UNDEFINED('u');

    final char typeChar;

    private ModelType(char typeChar) {
        this.typeChar = typeChar;
    }

    char getTypeChar() {
        return this.typeChar;
    }

    static ModelType forChar(char c) {
        switch (c) {
            case 'J': {
                return LONG;
            }
            case 'I': {
                return INT;
            }
            case 'Z': {
                return BOOLEAN;
            }
            case 's': {
                return STRING;
            }
            case 'D': {
                return DOUBLE;
            }
            case 'd': {
                return BIG_DECIMAL;
            }
            case 'i': {
                return BIG_INTEGER;
            }
            case 'b': {
                return BYTES;
            }
            case 'l': {
                return LIST;
            }
            case 't': {
                return TYPE;
            }
            case 'o': {
                return OBJECT;
            }
            case 'p': {
                return PROPERTY;
            }
            case 'e': {
                return EXPRESSION;
            }
            case 'u': {
                return UNDEFINED;
            }
        }
        throw new IllegalArgumentException("Invalid type character '" + c + "'");
    }
}

