/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift;

import io.fabric8.api.Container;
import io.fabric8.api.ContainerAutoScaler;
import io.fabric8.api.Containers;
import io.fabric8.api.CreateContainerOptions;
import io.fabric8.api.FabricService;
import io.fabric8.api.NameValidator;
import io.fabric8.common.util.Maps;
import io.fabric8.common.util.Strings;
import io.fabric8.common.util.Systems;
import io.fabric8.openshift.CreateOpenshiftContainerOptions;
import io.fabric8.openshift.OpenshiftContainerProvider;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenShiftAutoScaler
implements ContainerAutoScaler {
    private static final transient Logger LOG = LoggerFactory.getLogger(OpenShiftAutoScaler.class);
    private final OpenshiftContainerProvider containerProvider;

    public OpenShiftAutoScaler(OpenshiftContainerProvider containerProvider) {
        this.containerProvider = containerProvider;
    }

    public int getWeight() {
        return 100;
    }

    public void createContainers(String version, String profile, int count) throws Exception {
        FabricService fabricService = this.containerProvider.getFabricService();
        CreateOpenshiftContainerOptions.Builder builder = null;
        if (fabricService != null) {
            builder = this.createAutoScaleOptions(fabricService);
        }
        if (builder != null) {
            for (int i = 0; i < count; ++i) {
                Container[] containers = fabricService.getContainers();
                CreateOpenshiftContainerOptions.Builder configuredBuilder = (CreateOpenshiftContainerOptions.Builder)((CreateOpenshiftContainerOptions.Builder)((CreateOpenshiftContainerOptions.Builder)builder.number(1)).version(version)).profiles(profile);
                NameValidator openShiftValidator = this.containerProvider.createNameValidator(configuredBuilder.build());
                NameValidator fabricNameValidator = Containers.createNameValidator((Container[])fabricService.getContainers());
                NameValidator nameValidator = Containers.joinNameValidators((NameValidator[])new NameValidator[]{openShiftValidator, fabricNameValidator});
                String name = Containers.createContainerName((Container[])containers, (String)profile, (String)this.containerProvider.getScheme(), (NameValidator)nameValidator);
                CreateOpenshiftContainerOptions options = ((CreateOpenshiftContainerOptions.Builder)configuredBuilder.name(name)).build();
                LOG.info("Creating container name " + name + " version " + version + " profile " + profile + " " + count + " container(s)");
                fabricService.createContainers((CreateContainerOptions)options);
            }
        } else {
            LOG.warn("Could not create version " + version + " profile " + profile + " due to missing autoscale configuration");
        }
    }

    protected CreateOpenshiftContainerOptions.Builder createAutoScaleOptions(FabricService fabricService) {
        CreateOpenshiftContainerOptions.Builder builder = CreateOpenshiftContainerOptions.builder();
        String zookeeperUrl = fabricService.getZookeeperUrl();
        String zookeeperPassword = fabricService.getZookeeperPassword();
        builder = (CreateOpenshiftContainerOptions.Builder)((CreateOpenshiftContainerOptions.Builder)builder.zookeeperUrl(zookeeperUrl)).zookeeperPassword(zookeeperPassword);
        Map<String, ?> properties = this.containerProvider.getConfiguration();
        String serverUrl = this.validateProperty(properties, "serverUrl", "autoscale.server.url", "OPENSHIFT_BROKER_HOST", "openshift.redhat.com");
        String domain = this.validateProperty(properties, "domain", "autoscale.domain", "OPENSHIFT_NAMESPACE", "");
        String login = this.validateProperty(properties, "login", "autoscale.login", "OPENSHIFT_LOGIN", "");
        String password = this.validateProperty(properties, "login", "autoscale.password", "OPENSHIFT_PASSWORD", "");
        if (Strings.isNotBlank((String)domain) && Strings.isNotBlank((String)login) && Strings.isNotBlank((String)password)) {
            LOG.info("Using serverUrl: " + serverUrl + " domain: " + domain + " login: " + login);
            return builder.serverUrl(serverUrl).domain(domain).login(login).password(password);
        }
        return null;
    }

    protected String validateProperty(Map<String, ?> properties, String name, String propertyName, String envVarName, String defaultValue) {
        String answer = Maps.stringValue(properties, (String)propertyName, (String)Systems.getEnvVar((String)envVarName, (String)defaultValue));
        if (Strings.isNullOrBlank((String)answer)) {
            LOG.warn("No configured value for " + name + " in property " + propertyName + " or environment variable $" + envVarName);
        }
        return answer;
    }

    public void destroyContainers(String profile, int count, List<Container> containers) {
    }
}

