/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.download;

import io.fabric8.agent.download.DownloadManager;
import io.fabric8.agent.download.DownloadManagers;
import io.fabric8.agent.mvn.Parser;
import io.fabric8.agent.utils.AgentUtils;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.Version;
import io.fabric8.utils.Files;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.karaf.features.Feature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileDownloader {
    private static final transient Logger LOG = LoggerFactory.getLogger(ProfileDownloader.class);
    private final FabricService fabricService;
    private final File target;
    private final boolean force;
    private final ExecutorService executorService;
    private final Set<File> processedFiles = new HashSet<File>();
    private boolean stopOnFailure;
    private final Map<String, Exception> errors = new HashMap<String, Exception>();

    public ProfileDownloader(FabricService fabricService, File target, boolean force, ExecutorService executorService) {
        this.fabricService = fabricService;
        this.target = target;
        this.force = force;
        this.executorService = executorService;
    }

    public void downloadVersion(Version version) throws Exception {
        Profile[] profiles;
        for (Profile profile : profiles = version.getProfiles()) {
            if (this.stopOnFailure) {
                this.downloadProfile(profile);
                continue;
            }
            try {
                this.downloadProfile(profile);
            }
            catch (Exception e) {
                String id = profile.getId();
                this.errors.put(id, e);
                LOG.error("Failed to download profile " + id + " " + e, (Throwable)e);
            }
        }
    }

    public void downloadProfile(Profile profile) throws Exception {
        if (!profile.isOverlay()) {
            profile = profile.getOverlay();
        }
        DownloadManager downloadManager = DownloadManagers.createDownloadManager(this.fabricService, profile, this.executorService);
        LinkedHashSet<String> bundles = new LinkedHashSet<String>();
        LinkedHashSet<Feature> features = new LinkedHashSet<Feature>();
        this.addMavenBundles(bundles, profile.getBundles());
        this.addMavenBundles(bundles, profile.getFabs());
        AgentUtils.addFeatures(features, downloadManager, profile);
        Map<String, File> files = AgentUtils.downloadBundles(downloadManager, features, bundles, Collections.<String>emptySet());
        Set<Map.Entry<String, File>> entries = files.entrySet();
        for (Map.Entry<String, File> entry : entries) {
            File destFile;
            String name = entry.getKey();
            File file = entry.getValue();
            if (!this.processedFiles.add(file)) continue;
            String fileName = file.getName();
            String mvnCoords = ProfileDownloader.getMavenCoords(name);
            if (mvnCoords != null) {
                Parser parser = new Parser(mvnCoords);
                destFile = new File(this.target, parser.getArtifactPath());
            } else {
                destFile = new File(this.target, fileName);
            }
            if (!this.force && destFile.exists()) continue;
            LOG.info("Copying file " + name + " to :  " + destFile.getCanonicalPath());
            Files.copy(file, destFile);
        }
    }

    public static String getMavenCoords(String bundle) {
        if (bundle.startsWith("mvn:")) {
            return bundle.substring(4);
        }
        int idx = bundle.indexOf(":mvn:", 1);
        if (idx > 0) {
            return bundle.substring(idx + 5);
        }
        return null;
    }

    public int getProcessedFileCount() {
        return this.processedFiles.size();
    }

    public List<String> getFailedProfileIDs() {
        return new ArrayList<String>(this.errors.keySet());
    }

    protected void addMavenBundles(Set<String> bundles, List<String> bundleList) {
        for (String bundle : bundleList) {
            String mvnCoords = ProfileDownloader.getMavenCoords(bundle);
            if (mvnCoords == null) continue;
            bundles.add(mvnCoords);
        }
    }
}

