/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.client;

import com.openshift.client.IField;
import com.openshift.client.ISeverity;
import com.openshift.client.Message;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Messages {
    private Map<IField, List<Message>> messagesByField;

    public Messages(Map<IField, List<Message>> messages) {
        this.messagesByField = messages;
    }

    public List<Message> getAll() {
        ArrayList<Message> allMessages = new ArrayList<Message>();
        for (List<Message> messages : this.messagesByField.values()) {
            for (Message message : messages) {
                allMessages.add(message);
            }
        }
        return allMessages;
    }

    public Message getFirstBy(IField field, ISeverity severity) {
        List<Message> messages = this.getBy(field, severity);
        if (messages == null || messages.size() == 0) {
            return null;
        }
        return messages.get(0);
    }

    public List<Message> getBy(IField field, ISeverity severity) {
        List<Message> messages = this.getBy(field);
        if (messages == null || messages.size() == 0) {
            return null;
        }
        ArrayList<Message> matchingMessages = new ArrayList<Message>();
        for (Message message : messages) {
            if (severity != null && !severity.equals(message.getSeverity())) continue;
            matchingMessages.add(message);
        }
        return matchingMessages;
    }

    public Message getFirstBy(IField field) {
        List<Message> messages = this.getBy(field);
        if (messages == null || messages.size() == 0) {
            return null;
        }
        return messages.get(0);
    }

    public List<Message> getBy(IField field) {
        if (this.messagesByField == null) {
            return null;
        }
        return this.messagesByField.get(field);
    }

    public boolean hasMessages() {
        for (List<Message> messages : this.messagesByField.values()) {
            if (messages.size() <= 0) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.getAll().size();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Message message : this.getAll()) {
            builder.append(message.getText()).append('\n');
        }
        return builder.toString();
    }
}

