/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.groups.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.fabric8.groups.Group;
import io.fabric8.groups.GroupListener;
import io.fabric8.groups.NodeState;
import io.fabric8.groups.internal.ChildData;
import io.fabric8.groups.internal.EventOperation;
import io.fabric8.groups.internal.GetDataOperation;
import io.fabric8.groups.internal.Operation;
import io.fabric8.groups.internal.RefreshOperation;
import io.fabric8.groups.internal.SequenceComparator;
import io.fabric8.groups.internal.UpdateOperation;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.Pathable;
import org.apache.curator.framework.api.WatchPathable;
import org.apache.curator.framework.listen.ListenerContainer;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.utils.EnsurePath;
import org.apache.curator.utils.ThreadUtils;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperGroup<T extends NodeState>
implements Group<T> {
    public static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperGroup.class);
    private final Class<T> clazz;
    private final CuratorFramework client;
    private final String path;
    private final ExecutorService executorService;
    private final EnsurePath ensurePath;
    private final BlockingQueue<Operation> operations = new LinkedBlockingQueue<Operation>();
    private final ListenerContainer<GroupListener<T>> listeners = new ListenerContainer();
    protected final ConcurrentMap<String, ChildData<T>> currentData = Maps.newConcurrentMap();
    private final AtomicBoolean started = new AtomicBoolean();
    private final AtomicBoolean connected = new AtomicBoolean();
    protected final SequenceComparator sequenceComparator = new SequenceComparator();
    private volatile String id;
    private volatile T state;
    private final Watcher childrenWatcher = new Watcher(){

        public void process(WatchedEvent event) {
            ZooKeeperGroup.this.offerOperation(new RefreshOperation(ZooKeeperGroup.this, RefreshMode.STANDARD));
        }
    };
    private final Watcher dataWatcher = new Watcher(){

        public void process(WatchedEvent event) {
            try {
                if (event.getType() == Watcher.Event.EventType.NodeDeleted) {
                    ZooKeeperGroup.this.remove(event.getPath());
                } else if (event.getType() == Watcher.Event.EventType.NodeDataChanged) {
                    ZooKeeperGroup.this.offerOperation(new GetDataOperation(ZooKeeperGroup.this, event.getPath()));
                }
            }
            catch (Exception e) {
                ZooKeeperGroup.this.handleException(e);
            }
        }
    };
    private final ConnectionStateListener connectionStateListener = new ConnectionStateListener(){

        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            ZooKeeperGroup.this.handleStateChange(newState);
        }
    };

    public ZooKeeperGroup(CuratorFramework client, String path, Class<T> clazz) {
        this(client, path, clazz, Executors.newSingleThreadExecutor(ThreadUtils.newThreadFactory((String)"ZooKeeperGroup")));
    }

    public ZooKeeperGroup(CuratorFramework client, String path, Class<T> clazz, ThreadFactory threadFactory) {
        this(client, path, clazz, Executors.newSingleThreadExecutor(threadFactory));
    }

    public ZooKeeperGroup(CuratorFramework client, String path, Class<T> clazz, ExecutorService executorService) {
        this.client = client;
        this.path = path;
        this.clazz = clazz;
        this.executorService = executorService;
        this.ensurePath = client.newNamespaceAwareEnsurePath(path);
    }

    @Override
    public void start() {
        if (this.started.compareAndSet(false, true)) {
            this.connected.set(this.client.getZookeeperClient().isConnected());
            this.client.getConnectionStateListenable().addListener((Object)this.connectionStateListener);
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    ZooKeeperGroup.this.mainLoop();
                }
            });
            if (this.isConnected()) {
                this.handleStateChange(ConnectionState.CONNECTED);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.started.compareAndSet(true, false)) {
            this.client.getConnectionStateListenable().removeListener((Object)this.connectionStateListener);
            this.executorService.shutdownNow();
            try {
                this.executorService.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw (IOException)new InterruptedIOException().initCause(e);
            }
            try {
                if (this.isConnected()) {
                    this.doUpdate(null);
                    this.callListeners(GroupListener.GroupEvent.DISCONNECTED);
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
            this.listeners.clear();
        }
    }

    @Override
    public boolean isConnected() {
        return this.connected.get();
    }

    @Override
    public void add(GroupListener<T> listener) {
        this.listeners.addListener(listener);
    }

    @Override
    public void remove(GroupListener<T> listener) {
        this.listeners.removeListener(listener);
    }

    @Override
    public void update(T state) {
        T oldState = this.state;
        this.state = state;
        if (this.started.get()) {
            boolean update;
            boolean bl = update = state == null && oldState != null || state != null && oldState == null || !Arrays.equals(this.encode(state), this.encode(oldState));
            if (update) {
                this.offerOperation(new RefreshOperation(this, RefreshMode.FORCE_GET_DATA_AND_STAT));
                this.offerOperation(new UpdateOperation<T>(this, state));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUpdate(T state) throws Exception {
        if (this.isConnected()) {
            if (state == null) {
                if (this.id != null) {
                    try {
                        this.client.delete().guaranteed().forPath(this.id);
                    }
                    catch (KeeperException.NoNodeException e) {
                    }
                    finally {
                        this.id = null;
                    }
                }
            } else {
                if (this.id == null) {
                    this.refresh(RefreshMode.FORCE_GET_DATA_AND_STAT);
                    Map<String, T> members = this.members();
                    for (Map.Entry<String, T> entry : members.entrySet()) {
                        NodeState v = (NodeState)entry.getValue();
                        if (!((NodeState)state).getContainer().equals(v.getContainer())) continue;
                        this.id = entry.getKey();
                        return;
                    }
                }
                if (this.id == null) {
                    this.id = (String)((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL_SEQUENTIAL)).forPath(this.path + "/0", this.encode(state));
                } else {
                    try {
                        this.client.setData().forPath(this.id, this.encode(state));
                    }
                    catch (KeeperException.NoNodeException e) {
                        this.id = (String)((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL_SEQUENTIAL)).forPath(this.path + "/0", this.encode(state));
                    }
                }
            }
        }
    }

    @Override
    public Map<String, T> members() {
        ArrayList children = new ArrayList(this.currentData.values());
        Collections.sort(children, this.sequenceComparator);
        LinkedHashMap members = new LinkedHashMap();
        for (ChildData child : children) {
            members.put(child.getPath(), child.getNode());
        }
        return members;
    }

    @Override
    public boolean isMaster() {
        ArrayList children = new ArrayList(this.currentData.values());
        Collections.sort(children, this.sequenceComparator);
        return !children.isEmpty() && ((ChildData)children.get(0)).getPath().equals(this.id);
    }

    @Override
    public T master() {
        ArrayList children = new ArrayList(this.currentData.values());
        Collections.sort(children, this.sequenceComparator);
        if (children.isEmpty()) {
            return null;
        }
        return (T)((NodeState)((ChildData)children.get(0)).getNode());
    }

    @Override
    public List<T> slaves() {
        ArrayList children = new ArrayList(this.currentData.values());
        Collections.sort(children, this.sequenceComparator);
        ArrayList slaves = new ArrayList();
        for (int i = 1; i < children.size(); ++i) {
            slaves.add(((ChildData)children.get(i)).getNode());
        }
        return slaves;
    }

    @Override
    public T getLastState() {
        return this.state;
    }

    public ListenerContainer<GroupListener<T>> getListenable() {
        return this.listeners;
    }

    public List<ChildData> getCurrentData() {
        return ImmutableList.copyOf((Collection)Sets.newTreeSet(this.currentData.values()));
    }

    public ChildData getCurrentData(String fullPath) {
        return (ChildData)this.currentData.get(fullPath);
    }

    public void clearAndRefresh() throws Exception {
        this.clearAndRefresh(false, false);
    }

    public void clearAndRefresh(boolean force, boolean sync) throws Exception {
        RefreshMode mode = force ? RefreshMode.FORCE_GET_DATA_AND_STAT : RefreshMode.STANDARD;
        this.currentData.clear();
        if (sync) {
            this.refresh(mode);
        } else {
            this.offerOperation(new RefreshOperation(this, mode));
        }
    }

    public void clear() {
        this.currentData.clear();
    }

    void refresh(RefreshMode mode) throws Exception {
        this.ensurePath.ensure(this.client.getZookeeperClient());
        List children = (List)((BackgroundPathable)this.client.getChildren().usingWatcher(this.childrenWatcher)).forPath(this.path);
        Collections.sort(children, new Comparator<String>(){

            @Override
            public int compare(String left, String right) {
                return left.compareTo(right);
            }
        });
        this.processChildren(children, mode);
    }

    void callListeners(final GroupListener.GroupEvent event) {
        this.listeners.forEach(new Function<GroupListener<T>, Void>(){

            public Void apply(GroupListener<T> listener) {
                try {
                    listener.groupEvent(ZooKeeperGroup.this, event);
                }
                catch (Exception e) {
                    ZooKeeperGroup.this.handleException(e);
                }
                return null;
            }
        });
    }

    void getDataAndStat(String fullPath) throws Exception {
        Stat stat = new Stat();
        byte[] data = (byte[])((Pathable)((WatchPathable)this.client.getData().storingStatIn(stat)).usingWatcher(this.dataWatcher)).forPath(fullPath);
        this.applyNewData(fullPath, KeeperException.Code.OK.intValue(), stat, data);
    }

    protected void handleException(Throwable e) {
        LOG.error("", e);
    }

    @VisibleForTesting
    protected void remove(String fullPath) {
        ChildData data = (ChildData)this.currentData.remove(fullPath);
        if (data != null) {
            this.offerOperation(new EventOperation(this, GroupListener.GroupEvent.CHANGED));
        }
    }

    private void internalRebuildNode(String fullPath) throws Exception {
        try {
            Stat stat = new Stat();
            byte[] bytes = (byte[])((WatchPathable)this.client.getData().storingStatIn(stat)).forPath(fullPath);
            this.currentData.put(fullPath, new ChildData<T>(fullPath, stat, bytes, this.decode(bytes)));
        }
        catch (KeeperException.NoNodeException ignore) {
            this.currentData.remove(fullPath);
        }
    }

    private void handleStateChange(ConnectionState newState) {
        switch (newState) {
            case SUSPENDED: 
            case LOST: {
                this.connected.set(false);
                this.clear();
                this.offerOperation(new EventOperation(this, GroupListener.GroupEvent.DISCONNECTED));
                break;
            }
            case CONNECTED: 
            case RECONNECTED: {
                this.connected.set(true);
                this.offerOperation(new RefreshOperation(this, RefreshMode.FORCE_GET_DATA_AND_STAT));
                this.offerOperation(new UpdateOperation<T>(this, this.state));
                this.offerOperation(new EventOperation(this, GroupListener.GroupEvent.CONNECTED));
            }
        }
    }

    private void processChildren(List<String> children, RefreshMode mode) throws Exception {
        ArrayList fullPaths = Lists.newArrayList((Iterable)Lists.transform(children, (Function)new Function<String, String>(){

            public String apply(String child) {
                return ZKPaths.makePath((String)ZooKeeperGroup.this.path, (String)child);
            }
        }));
        HashSet removedNodes = Sets.newHashSet(this.currentData.keySet());
        removedNodes.removeAll(fullPaths);
        for (String fullPath : removedNodes) {
            this.remove(fullPath);
        }
        for (String name : children) {
            String fullPath = ZKPaths.makePath((String)this.path, (String)name);
            if (mode != RefreshMode.FORCE_GET_DATA_AND_STAT && this.currentData.containsKey(fullPath)) continue;
            try {
                this.getDataAndStat(fullPath);
            }
            catch (KeeperException.NoNodeException ignore) {}
        }
    }

    private void applyNewData(String fullPath, int resultCode, Stat stat, byte[] bytes) {
        ChildData<T> data;
        ChildData<T> previousData;
        if (resultCode == KeeperException.Code.OK.intValue() && ((previousData = this.currentData.put(fullPath, data = new ChildData<T>(fullPath, stat, bytes, this.decode(bytes)))) == null || previousData.getStat().getVersion() != stat.getVersion())) {
            this.offerOperation(new EventOperation(this, GroupListener.GroupEvent.CHANGED));
        }
    }

    private void mainLoop() {
        while (this.started.get() && !Thread.currentThread().isInterrupted()) {
            try {
                this.operations.take().invoke();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    private byte[] encode(T state) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            MAPPER.writeValue((OutputStream)baos, state);
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to decode data", e);
        }
    }

    private T decode(byte[] data) {
        try {
            return (T)((NodeState)MAPPER.readValue(data, this.clazz));
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to decode data", e);
        }
    }

    private void offerOperation(Operation operation) {
        this.operations.remove(operation);
        this.operations.offer(operation);
    }

    public static <T> Map<String, T> members(CuratorFramework curator, String path, Class<T> clazz) throws Exception {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        List nodes = (List)curator.getChildren().forPath(path);
        ObjectMapper mapper = new ObjectMapper();
        for (String node : nodes) {
            byte[] data = (byte[])curator.getData().forPath(path + "/" + node);
            Object val = mapper.readValue(data, clazz);
            map.put(node, val);
        }
        return map;
    }

    public String getId() {
        return this.id;
    }

    static enum RefreshMode {
        STANDARD,
        FORCE_GET_DATA_AND_STAT;

    }
}

