/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jgit.api.CherryPickResult;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.MultipleParentsNotAllowedException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.NoMessageException;
import org.eclipse.jgit.api.errors.UnmergedPathsException;
import org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeMessageFormatter;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.FileTreeIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CherryPickCommand
extends GitCommand<CherryPickResult> {
    private String reflogPrefix = "cherry-pick:";
    private List<Ref> commits = new LinkedList<Ref>();
    private String ourCommitName = null;
    private MergeStrategy strategy = MergeStrategy.RECURSIVE;
    private Integer mainlineParentNumber;

    protected CherryPickCommand(Repository repo) {
        super(repo);
    }

    @Override
    public CherryPickResult call() throws GitAPIException, NoMessageException, UnmergedPathsException, ConcurrentRefUpdateException, WrongRepositoryStateException, NoHeadException {
        RevCommit newHead = null;
        LinkedList<Ref> cherryPickedRefs = new LinkedList<Ref>();
        this.checkCallable();
        RevWalk revWalk = new RevWalk(this.repo);
        try {
            Ref headRef = this.repo.getRef("HEAD");
            if (headRef == null) {
                throw new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
            }
            newHead = revWalk.parseCommit(headRef.getObjectId());
            for (Ref src : this.commits) {
                Object dco;
                ObjectId srcObjectId = src.getPeeledObjectId();
                if (srcObjectId == null) {
                    srcObjectId = src.getObjectId();
                }
                RevCommit srcCommit = revWalk.parseCommit(srcObjectId);
                RevCommit srcParent = this.getParentCommit(srcCommit, revWalk);
                String ourName = this.calculateOurName(headRef);
                String cherryPickName = srcCommit.getId().abbreviate(7).name() + " " + srcCommit.getShortMessage();
                ResolveMerger merger = (ResolveMerger)this.strategy.newMerger(this.repo);
                merger.setWorkingTreeIterator(new FileTreeIterator(this.repo));
                merger.setBase(srcParent.getTree());
                merger.setCommitNames(new String[]{"BASE", ourName, cherryPickName});
                if (merger.merge(newHead, srcCommit)) {
                    if (AnyObjectId.equals(newHead.getTree().getId(), merger.getResultTreeId())) continue;
                } else {
                    if (merger.failed()) {
                        dco = new CherryPickResult(merger.getFailingPaths());
                        return dco;
                    }
                    String message = new MergeMessageFormatter().formatWithConflicts(srcCommit.getFullMessage(), merger.getUnmergedPaths());
                    this.repo.writeCherryPickHead(srcCommit.getId());
                    this.repo.writeMergeCommitMsg(message);
                    CherryPickResult cherryPickResult = CherryPickResult.CONFLICT;
                    return cherryPickResult;
                }
                dco = new DirCacheCheckout(this.repo, newHead.getTree(), this.repo.lockDirCache(), merger.getResultTreeId());
                ((DirCacheCheckout)dco).setFailOnConflict(true);
                ((DirCacheCheckout)dco).checkout();
                newHead = new Git(this.getRepository()).commit().setMessage(srcCommit.getFullMessage()).setReflogComment(this.reflogPrefix + " " + srcCommit.getShortMessage()).setAuthor(srcCommit.getAuthorIdent()).call();
                cherryPickedRefs.add(src);
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionCaughtDuringExecutionOfCherryPickCommand, e), e);
        }
        finally {
            revWalk.release();
        }
        return new CherryPickResult(newHead, cherryPickedRefs);
    }

    private RevCommit getParentCommit(RevCommit srcCommit, RevWalk revWalk) throws MultipleParentsNotAllowedException, MissingObjectException, IOException {
        RevCommit srcParent;
        if (this.mainlineParentNumber == null) {
            if (srcCommit.getParentCount() != 1) {
                throw new MultipleParentsNotAllowedException(MessageFormat.format(JGitText.get().canOnlyCherryPickCommitsWithOneParent, srcCommit.name(), srcCommit.getParentCount()));
            }
            srcParent = srcCommit.getParent(0);
        } else {
            if (this.mainlineParentNumber > srcCommit.getParentCount()) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().commitDoesNotHaveGivenParent, srcCommit, this.mainlineParentNumber));
            }
            srcParent = srcCommit.getParent(this.mainlineParentNumber - 1);
        }
        revWalk.parseHeaders(srcParent);
        return srcParent;
    }

    public CherryPickCommand include(Ref commit) {
        this.checkCallable();
        this.commits.add(commit);
        return this;
    }

    public CherryPickCommand include(AnyObjectId commit) {
        return this.include(commit.getName(), commit);
    }

    public CherryPickCommand include(String name, AnyObjectId commit) {
        return this.include(new ObjectIdRef.Unpeeled(Ref.Storage.LOOSE, name, commit.copy()));
    }

    public CherryPickCommand setOurCommitName(String ourCommitName) {
        this.ourCommitName = ourCommitName;
        return this;
    }

    public CherryPickCommand setReflogPrefix(String prefix) {
        this.reflogPrefix = prefix;
        return this;
    }

    public CherryPickCommand setStrategy(MergeStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public CherryPickCommand setMainlineParentNumber(int mainlineParentNumber) {
        this.mainlineParentNumber = mainlineParentNumber;
        return this;
    }

    private String calculateOurName(Ref headRef) {
        if (this.ourCommitName != null) {
            return this.ourCommitName;
        }
        String targetRefName = headRef.getTarget().getName();
        String headName = Repository.shortenRefName(targetRefName);
        return headName;
    }
}

