/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core.filter.tree;

import java.io.IOException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.gitective.core.filter.commit.CommitFilter;
import org.gitective.core.filter.tree.BaseTreeFilter;

public class CommitTreeFilter
extends CommitFilter {
    private final BaseTreeFilter filter;

    public CommitTreeFilter(TreeFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Filter cannot be null");
        }
        this.filter = filter instanceof BaseTreeFilter ? (BaseTreeFilter)filter : new FilterWrapper(filter);
    }

    public CommitFilter setRepository(Repository repository) {
        this.filter.setRepository(repository);
        return super.setRepository(repository);
    }

    public CommitFilter reset() {
        this.filter.reset();
        return super.reset();
    }

    public boolean include(RevWalk walker, RevCommit commit) throws IOException {
        TreeWalk walk = new TreeWalk(walker.getObjectReader());
        walk.addTree(commit.getTree());
        while (walk.next()) {
            if (!this.filter.include(walker, commit, walk)) {
                return this.include(false);
            }
            if (!walk.isSubtree()) continue;
            walk.enterSubtree();
        }
        return true;
    }

    protected static class FilterWrapper
    extends BaseTreeFilter {
        private final TreeFilter filter;

        protected FilterWrapper(TreeFilter filter) {
            this.filter = filter;
        }

        public boolean include(TreeWalk walker) throws IOException {
            return this.filter.include(walker);
        }
    }
}

