/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepository;
import org.gitective.core.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryService {
    protected final Repository[] repositories;

    public RepositoryService(String ... gitDirs) {
        if (gitDirs == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Directories"));
        }
        if (gitDirs.length == 0) {
            throw new IllegalArgumentException(Assert.formatNotEmpty("Directories"));
        }
        int length = gitDirs.length;
        this.repositories = new Repository[length];
        try {
            for (int i = 0; i < length; ++i) {
                this.repositories[i] = new FileRepository(gitDirs[i]);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public RepositoryService(File ... gitDirs) {
        if (gitDirs == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Directories"));
        }
        if (gitDirs.length == 0) {
            throw new IllegalArgumentException(Assert.formatNotEmpty("Directories"));
        }
        int length = gitDirs.length;
        this.repositories = new Repository[length];
        try {
            for (int i = 0; i < length; ++i) {
                this.repositories[i] = new FileRepository(gitDirs[i]);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public RepositoryService(Repository ... repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Repositories"));
        }
        if (repositories.length == 0) {
            throw new IllegalArgumentException(Assert.formatNotEmpty("Repositories"));
        }
        this.repositories = new Repository[repositories.length];
        System.arraycopy(repositories, 0, this.repositories, 0, repositories.length);
    }

    public RepositoryService(Collection<?> repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Repositories"));
        }
        if (repositories.isEmpty()) {
            throw new IllegalArgumentException(Assert.formatNotEmpty("Repositories"));
        }
        ArrayList<Object> created = new ArrayList<Object>(repositories.size());
        try {
            for (Object repo : repositories) {
                if (repo instanceof String) {
                    created.add(new FileRepository((String)repo));
                    continue;
                }
                if (repo instanceof File) {
                    created.add(new FileRepository((File)repo));
                    continue;
                }
                if (!(repo instanceof Repository)) continue;
                created.add((Repository)repo);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        this.repositories = created.toArray(new Repository[created.size()]);
    }
}

