/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core.filter.commit;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.gitective.core.filter.commit.CommitFilter;
import org.gitective.core.filter.commit.CommitMessageFindFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugSetFilter
extends CommitMessageFindFilter {
    private final Set<String> bugs = new HashSet<String>();

    public BugSetFilter() {
        super("^Bug: (\\w+)$", 8);
    }

    public Set<String> getBugs() {
        return this.bugs;
    }

    @Override
    public boolean include(RevWalk walker, RevCommit commit) throws IOException {
        this.matcher.reset(this.getText(commit));
        while (this.matcher.find()) {
            this.bugs.add(this.matcher.group(1));
        }
        return true;
    }

    @Override
    public RevFilter clone() {
        return new BugSetFilter();
    }

    @Override
    public CommitFilter reset() {
        this.bugs.clear();
        return super.reset();
    }
}

