/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core.filter.commit;

import java.util.Collection;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.gitective.core.filter.commit.CommitDiffFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffFileSizeFilter
extends CommitDiffFilter {
    private final int total;

    public DiffFileSizeFilter(boolean detectRenames, int diffTotal) {
        super(detectRenames);
        this.total = diffTotal;
    }

    public DiffFileSizeFilter(int diffTotal) {
        this(false, diffTotal);
    }

    public int getTotal() {
        return this.total;
    }

    @Override
    public boolean include(RevCommit commit, Collection<DiffEntry> diffs) {
        if (diffs.size() < this.total) {
            return false;
        }
        int count = 0;
        for (DiffEntry diff : diffs) {
            switch (diff.getChangeType()) {
                case ADD: 
                case MODIFY: 
                case DELETE: {
                    if (++count < this.total) break;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public RevFilter clone() {
        return new DiffFileSizeFilter(this.detectRenames, this.total);
    }
}

