/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.git.http;

import io.fabric8.zookeeper.ZkPath;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.shared.SharedCount;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.http.server.GitServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricGitServlet
extends GitServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(FabricGitServlet.class);
    private final CuratorFramework curator;
    private SharedCount counter;
    private Git git;

    FabricGitServlet(Git git, CuratorFramework curator) {
        this.curator = curator;
        this.git = git;
    }

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this.counter = new SharedCount(this.curator, ZkPath.GIT_TRIGGER.getPath(new String[0]), 0);
            this.counter.start();
        }
        catch (Exception ex) {
            LOGGER.error("Error starting SharedCount", (Throwable)ex);
            throw new ServletException("Error starting SharedCount", (Throwable)ex);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        try {
            this.counter.close();
        }
        catch (IOException ex) {
            LOGGER.warn("Error closing SharedCount due to: " + ex + ". This exception is ignored.");
        }
    }

    @Override
    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        LOGGER.debug("GitHttp service req={}", (Object)req);
        super.service(req, res);
        LOGGER.debug("GitHttp service res={}", (Object)res);
        String resContentType = res.getContentType();
        if (resContentType.contains("x-git-receive-pack-result")) {
            LOGGER.info("GitHttp service res={}", (Object)res);
            int httpStatus = 0;
            try {
                Method method = res.getClass().getMethod("getStatus", new Class[0]);
                httpStatus = (Integer)method.invoke((Object)res, new Object[0]);
            }
            catch (Exception ex) {
                LOGGER.error("Cannot obtain http response code: " + ex);
            }
            if (httpStatus == 200) {
                try {
                    List refs = this.git.branchList().call();
                    LOGGER.info("Remote git content updated: {}", (Object)refs);
                    while (!this.counter.trySetCount(this.counter.getCount() + 1)) {
                    }
                }
                catch (Exception ex) {
                    LOGGER.debug("Error incrementing shared counter: " + ex + ". This exception is ignored.", (Throwable)ex);
                    LOGGER.warn("Error incrementing shared counter: " + ex + ". This exception is ignored.");
                }
            }
        }
    }
}

