/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.utils;

import io.fabric8.common.util.ChecksumUtils;
import io.fabric8.common.util.Closeables;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.osgi.framework.BundleContext;

public class DataStoreUtils {
    public static byte[] toBytes(Properties source) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        source.store(baos, null);
        return baos.toByteArray();
    }

    public static byte[] toBytes(Map<String, String> source) throws IOException {
        return DataStoreUtils.toBytes(DataStoreUtils.toProperties(source));
    }

    public static Properties toProperties(byte[] source) throws IOException {
        Properties rc = new Properties();
        if (source != null) {
            rc.load(new ByteArrayInputStream(source));
        }
        return rc;
    }

    public static Map<String, String> toMap(Properties source) {
        HashMap<String, String> rc = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : source.entrySet()) {
            rc.put((String)entry.getKey(), (String)entry.getValue());
        }
        return rc;
    }

    public static Map<String, String> toMap(byte[] source) throws IOException {
        return DataStoreUtils.toMap(DataStoreUtils.toProperties(source));
    }

    public static Properties toProperties(Map<String, String> source) {
        Properties rc = new Properties();
        for (Map.Entry<String, String> entry : source.entrySet()) {
            rc.put(entry.getKey(), entry.getValue());
        }
        return rc;
    }

    public static Properties toStringProperties(Map<String, ?> source) {
        Properties rc = new Properties();
        for (Map.Entry<String, ?> entry : source.entrySet()) {
            Object value = entry.getValue();
            if (value == null) continue;
            rc.put(entry.getKey(), value.toString());
        }
        return rc;
    }

    public static String stripSuffix(String value, String suffix) throws IOException {
        if (value.endsWith(suffix)) {
            return value.substring(0, value.length() - suffix.length());
        }
        return value;
    }

    public static String toString(Properties source) throws IOException {
        StringWriter writer = new StringWriter();
        source.store(writer, null);
        return writer.toString();
    }

    public static Properties toProperties(String source) throws IOException {
        Properties rc = new Properties();
        rc.load(new StringReader(source));
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String substituteChecksum(String key) {
        InputStream is = null;
        try {
            URL url = new URL(key.substring("checksum:".length()));
            is = url.openStream();
            String string = String.valueOf(ChecksumUtils.checksum((InputStream)is));
            Closeables.closeQuitely((Closeable)is);
            return string;
        }
        catch (Exception ex) {
            String string = "0";
            return string;
        }
        finally {
            Closeables.closeQuitely(is);
        }
    }

    public static String substituteProfileProperty(String key, Map<String, Map<String, String>> configs) {
        String pid = key.substring("profile:".length(), key.indexOf("/"));
        String propertyKey = key.substring(key.indexOf("/") + 1);
        Map<String, String> targetProps = configs.get(pid);
        if (targetProps != null && targetProps.containsKey(propertyKey)) {
            return targetProps.get(propertyKey);
        }
        return key;
    }

    public static String substituteBundleProperty(String key, BundleContext bundleContext) {
        String value = null;
        if (bundleContext != null) {
            value = bundleContext.getProperty(key);
        }
        if (value == null) {
            value = System.getProperty(key);
        }
        return value != null ? value : "";
    }
}

