/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api;

import io.fabric8.docker.api.Docker;
import io.fabric8.docker.api.support.ProgressBodyReader;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.plugins.providers.DefaultTextPlain;
import org.jboss.resteasy.plugins.providers.FileProvider;
import org.jboss.resteasy.plugins.providers.InputStreamProvider;
import org.jboss.resteasy.plugins.providers.StringTextStar;
import org.jboss.resteasy.plugins.providers.jackson.Jackson2JsonpInterceptor;
import org.jboss.resteasy.plugins.providers.jackson.ResteasyJackson2Provider;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class DockerFactory {
    public static final String DEFAULT_DOCKER_HOST = "tcp://localhost:2375";
    private String address;

    public DockerFactory() {
        this.findDocker();
        this.init();
    }

    public DockerFactory(String address) {
        this.address = address;
        if (DockerFactory.isEmpty(address)) {
            this.findDocker();
        }
        this.init();
    }

    protected void findDocker() {
        this.address = DockerFactory.resolveHttpDockerHost();
    }

    private void init() {
    }

    public String toString() {
        return "DockerFactory{" + this.address + '}';
    }

    public Docker createDocker() {
        ResteasyProviderFactory providerFactory = ResteasyProviderFactory.getInstance();
        providerFactory.register((Class)ResteasyJackson2Provider.class);
        providerFactory.register((Class)Jackson2JsonpInterceptor.class);
        providerFactory.register((Class)ProgressBodyReader.class);
        providerFactory.register((Class)StringTextStar.class);
        providerFactory.register((Class)DefaultTextPlain.class);
        providerFactory.register((Class)FileProvider.class);
        providerFactory.register((Class)InputStreamProvider.class);
        ResteasyClientBuilder builder = new ResteasyClientBuilder();
        builder.providerFactory(providerFactory);
        builder.connectionPoolSize(Integer.parseInt(System.getProperty("docker.connection.pool", "3")));
        ResteasyClient client = builder.build();
        ResteasyWebTarget target = (ResteasyWebTarget)client.target(this.address);
        return target.proxy(Docker.class);
    }

    public String getDockerHost() {
        String answer = this.address;
        int idx = answer.lastIndexOf(":");
        if (idx > 0) {
            answer = answer.substring(0, idx);
        }
        if ((idx = answer.lastIndexOf(":")) > 0) {
            answer = answer.substring(idx + 1);
        }
        if ((idx = answer.lastIndexOf("/")) > 0) {
            answer = answer.substring(idx + 1);
        }
        return answer;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
        if (DockerFactory.isEmpty(address)) {
            this.findDocker();
        }
    }

    protected static boolean isEmpty(String text) {
        return text == null || text.length() == 0;
    }

    public static String resolveHttpDockerHost() {
        String dockerHost = DockerFactory.resolveDockerHost();
        if (dockerHost.startsWith("tcp:")) {
            return "http:" + dockerHost.substring(4);
        }
        return dockerHost;
    }

    public static String resolveDockerHost() {
        String dockerHost = System.getenv("DOCKER_HOST");
        if (DockerFactory.isEmpty(dockerHost)) {
            dockerHost = System.getProperty("docker.host");
        }
        if (!DockerFactory.isEmpty(dockerHost)) {
            return dockerHost;
        }
        return DEFAULT_DOCKER_HOST;
    }
}

