/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.interceptors.encoding;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import javax.annotation.Priority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.ReaderInterceptorContext;

@Provider
@Priority(value=4000)
public class GZIPDecodingInterceptor
implements ReaderInterceptor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object aroundReadFrom(ReaderInterceptorContext context) throws IOException, WebApplicationException {
        String encoding = context.getHeaders().getFirst("Content-Encoding");
        if (encoding != null && encoding.toString().equalsIgnoreCase("gzip")) {
            InputStream old = context.getInputStream();
            FinishableGZIPInputStream is = new FinishableGZIPInputStream(old);
            context.setInputStream(is);
            try {
                Object object = context.proceed();
                return object;
            }
            finally {
                if (!context.getType().equals(InputStream.class)) {
                    is.finish();
                }
                context.setInputStream(old);
            }
        }
        return context.proceed();
    }

    public static class FinishableGZIPInputStream
    extends GZIPInputStream {
        public FinishableGZIPInputStream(InputStream is) throws IOException {
            super(is);
        }

        public void finish() {
            this.inf.end();
        }
    }
}

