/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.spi;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.specimpl.PathSegmentImpl;
import org.jboss.resteasy.specimpl.ResteasyUriBuilder;
import org.jboss.resteasy.util.Encode;

public class ResteasyUriInfo
implements UriInfo {
    private String path;
    private String encodedPath;
    private String matchingPath;
    private MultivaluedMap<String, String> queryParameters;
    private MultivaluedMap<String, String> encodedQueryParameters;
    private MultivaluedMap<String, String> pathParameters;
    private MultivaluedMap<String, String> encodedPathParameters;
    private MultivaluedMap<String, PathSegment[]> pathParameterPathSegments;
    private MultivaluedMap<String, PathSegment[]> encodedPathParameterPathSegments;
    private List<PathSegment> pathSegments;
    private List<PathSegment> encodedPathSegments;
    private URI absolutePath;
    private URI requestURI;
    private URI baseURI;
    private List<String> matchedUris;
    private List<String> encodedMatchedUris;
    private List<String> encodedMatchedPaths = new ArrayList<String>();
    private List<Object> ancestors;

    public ResteasyUriInfo(URI base, URI relative) {
        String r;
        String b = base.toString();
        if (!b.endsWith("/")) {
            b = b + "/";
        }
        if ((r = relative.getRawPath()).startsWith("/")) {
            this.encodedPath = r;
            this.path = relative.getPath();
        } else {
            this.encodedPath = "/" + r;
            this.path = "/" + relative.getPath();
        }
        this.requestURI = UriBuilder.fromUri(base).path(relative.getRawPath()).replaceQuery(relative.getRawQuery()).build(new Object[0]);
        this.baseURI = base;
        this.encodedPathSegments = PathSegmentImpl.parseSegments(this.encodedPath, false);
        this.pathSegments = new ArrayList<PathSegment>(this.encodedPathSegments.size());
        for (PathSegment segment : this.encodedPathSegments) {
            this.pathSegments.add(new PathSegmentImpl(((PathSegmentImpl)segment).getOriginal(), true));
        }
        this.extractParameters(this.requestURI.getRawQuery());
        this.extractMatchingPath(this.encodedPathSegments);
        this.absolutePath = UriBuilder.fromUri(this.requestURI).replaceQuery(null).build(new Object[0]);
    }

    public ResteasyUriInfo(URI requestURI) {
        String r = requestURI.getRawPath();
        if (r.startsWith("/")) {
            this.encodedPath = r;
            this.path = requestURI.getPath();
        } else {
            this.encodedPath = "/" + r;
            this.path = "/" + requestURI.getPath();
        }
        this.requestURI = requestURI;
        this.baseURI = UriBuilder.fromUri(requestURI).replacePath("").build(new Object[0]);
        this.encodedPathSegments = PathSegmentImpl.parseSegments(this.encodedPath, false);
        this.pathSegments = new ArrayList<PathSegment>(this.encodedPathSegments.size());
        for (PathSegment segment : this.encodedPathSegments) {
            this.pathSegments.add(new PathSegmentImpl(((PathSegmentImpl)segment).getOriginal(), true));
        }
        this.extractParameters(requestURI.getRawQuery());
        this.extractMatchingPath(this.encodedPathSegments);
        this.absolutePath = UriBuilder.fromUri(requestURI).replaceQuery(null).build(new Object[0]);
    }

    protected void extractMatchingPath(List<PathSegment> encodedPathSegments) {
        StringBuilder preprocessedPath = new StringBuilder();
        for (PathSegment pathSegment : encodedPathSegments) {
            preprocessedPath.append("/").append(pathSegment.getPath());
        }
        this.matchingPath = preprocessedPath.toString();
    }

    public String getMatchingPath() {
        return this.matchingPath;
    }

    public ResteasyUriInfo setRequestUri(URI relative) {
        String rel = relative.toString();
        if (rel.startsWith(this.baseURI.toString())) {
            relative = URI.create(rel.substring(this.baseURI.toString().length()));
        }
        return new ResteasyUriInfo(this.baseURI, relative);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getPath(boolean decode) {
        if (decode) {
            return this.getPath();
        }
        return this.encodedPath;
    }

    @Override
    public List<PathSegment> getPathSegments() {
        return this.pathSegments;
    }

    @Override
    public List<PathSegment> getPathSegments(boolean decode) {
        if (decode) {
            return this.getPathSegments();
        }
        return this.encodedPathSegments;
    }

    @Override
    public URI getRequestUri() {
        return this.requestURI;
    }

    @Override
    public UriBuilder getRequestUriBuilder() {
        return UriBuilder.fromUri(this.requestURI);
    }

    @Override
    public URI getAbsolutePath() {
        return this.absolutePath;
    }

    @Override
    public UriBuilder getAbsolutePathBuilder() {
        return UriBuilder.fromUri(this.absolutePath);
    }

    @Override
    public URI getBaseUri() {
        return this.baseURI;
    }

    @Override
    public UriBuilder getBaseUriBuilder() {
        return UriBuilder.fromUri(this.baseURI);
    }

    @Override
    public MultivaluedMap<String, String> getPathParameters() {
        if (this.pathParameters == null) {
            this.pathParameters = new MultivaluedMapImpl<String, String>();
        }
        return this.pathParameters;
    }

    public void addEncodedPathParameter(String name, String value) {
        this.getEncodedPathParameters().add(name, value);
        String value1 = Encode.decodePath(value);
        this.getPathParameters().add(name, value1);
    }

    private MultivaluedMap<String, String> getEncodedPathParameters() {
        if (this.encodedPathParameters == null) {
            this.encodedPathParameters = new MultivaluedMapImpl<String, String>();
        }
        return this.encodedPathParameters;
    }

    public MultivaluedMap<String, PathSegment[]> getEncodedPathParameterPathSegments() {
        if (this.encodedPathParameterPathSegments == null) {
            this.encodedPathParameterPathSegments = new MultivaluedMapImpl<String, PathSegment[]>();
        }
        return this.encodedPathParameterPathSegments;
    }

    public MultivaluedMap<String, PathSegment[]> getPathParameterPathSegments() {
        if (this.pathParameterPathSegments == null) {
            this.pathParameterPathSegments = new MultivaluedMapImpl<String, PathSegment[]>();
        }
        return this.pathParameterPathSegments;
    }

    @Override
    public MultivaluedMap<String, String> getPathParameters(boolean decode) {
        if (decode) {
            return this.getPathParameters();
        }
        return this.getEncodedPathParameters();
    }

    @Override
    public MultivaluedMap<String, String> getQueryParameters() {
        if (this.queryParameters == null) {
            this.queryParameters = new MultivaluedMapImpl<String, String>();
        }
        return this.queryParameters;
    }

    protected MultivaluedMap<String, String> getEncodedQueryParameters() {
        if (this.encodedQueryParameters == null) {
            this.encodedQueryParameters = new MultivaluedMapImpl<String, String>();
        }
        return this.encodedQueryParameters;
    }

    @Override
    public MultivaluedMap<String, String> getQueryParameters(boolean decode) {
        if (decode) {
            return this.getQueryParameters();
        }
        return this.getEncodedQueryParameters();
    }

    protected void extractParameters(String queryString) {
        String[] params;
        if (queryString == null || queryString.equals("")) {
            return;
        }
        for (String param : params = queryString.split("&")) {
            if (param.indexOf(61) >= 0) {
                String[] nv = param.split("=", 2);
                try {
                    String name = URLDecoder.decode(nv[0], "UTF-8");
                    String val = nv.length > 1 ? nv[1] : "";
                    this.getEncodedQueryParameters().add(name, val);
                    this.getQueryParameters().add(name, URLDecoder.decode(val, "UTF-8"));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                String name = URLDecoder.decode(param, "UTF-8");
                this.getEncodedQueryParameters().add(name, "");
                this.getQueryParameters().add(name, "");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public List<String> getMatchedURIs(boolean decode) {
        if (decode) {
            if (this.matchedUris == null) {
                this.matchedUris = new ArrayList<String>();
            }
            return this.matchedUris;
        }
        if (this.encodedMatchedUris == null) {
            this.encodedMatchedUris = new ArrayList<String>();
        }
        return this.encodedMatchedUris;
    }

    @Override
    public List<String> getMatchedURIs() {
        return this.getMatchedURIs(true);
    }

    @Override
    public List<Object> getMatchedResources() {
        if (this.ancestors == null) {
            this.ancestors = new ArrayList<Object>();
        }
        return this.ancestors;
    }

    public void pushCurrentResource(Object resource) {
        if (this.ancestors == null) {
            this.ancestors = new ArrayList<Object>();
        }
        this.ancestors.add(0, resource);
    }

    public void pushMatchedPath(String encoded) {
        this.encodedMatchedPaths.add(0, encoded);
    }

    public List<String> getEncodedMatchedPaths() {
        return this.encodedMatchedPaths;
    }

    public void popMatchedPath() {
        this.encodedMatchedPaths.remove(0);
    }

    public void pushMatchedURI(String encoded) {
        if (encoded.endsWith("/")) {
            encoded = encoded.substring(0, encoded.length() - 1);
        }
        if (encoded.startsWith("/")) {
            encoded = encoded.substring(1);
        }
        String decoded = Encode.decode(encoded);
        if (this.encodedMatchedUris == null) {
            this.encodedMatchedUris = new ArrayList<String>();
        }
        this.encodedMatchedUris.add(0, encoded);
        if (this.matchedUris == null) {
            this.matchedUris = new ArrayList<String>();
        }
        this.matchedUris.add(0, decoded);
    }

    @Override
    public URI resolve(URI uri) {
        return this.getBaseUri().resolve(uri);
    }

    @Override
    public URI relativize(URI uri) {
        URI from = this.getRequestUri();
        URI to = uri;
        if (uri.getScheme() == null && uri.getHost() == null) {
            to = this.getBaseUriBuilder().replaceQuery(null).path(uri.getPath()).replaceQuery(uri.getQuery()).fragment(uri.getFragment()).build(new Object[0]);
        }
        return ResteasyUriBuilder.relativize(from, to);
    }
}

