/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.specimpl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.core.Headers;
import org.jboss.resteasy.plugins.delegates.LocaleDelegate;
import org.jboss.resteasy.spi.HeaderValueProcessor;
import org.jboss.resteasy.spi.LinkHeaders;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.CaseInsensitiveMap;
import org.jboss.resteasy.util.DateUtil;

public class BuiltResponse
extends Response {
    protected Object entity;
    protected int status = 200;
    protected Headers<Object> metadata = new Headers();
    protected Annotation[] annotations;
    protected Class entityClass;
    protected Type genericType;
    protected HeaderValueProcessor processor;
    protected boolean isClosed;

    public BuiltResponse() {
    }

    public BuiltResponse(int status, Headers<Object> metadata, Object entity, Annotation[] entityAnnotations) {
        this.setEntity(entity);
        this.status = status;
        this.metadata = metadata;
        this.annotations = entityAnnotations;
    }

    public Class getEntityClass() {
        return this.entityClass;
    }

    public void setEntityClass(Class entityClass) {
        this.entityClass = entityClass;
    }

    protected HeaderValueProcessor getHeaderValueProcessor() {
        if (this.processor != null) {
            return this.processor;
        }
        return ResteasyProviderFactory.getInstance();
    }

    @Override
    public Object getEntity() {
        this.abortIfClosed();
        return this.entity;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public Response.StatusType getStatusInfo() {
        Response.StatusType statusType = Response.Status.fromStatusCode(this.status);
        if (statusType == null) {
            statusType = new Response.StatusType(){

                @Override
                public int getStatusCode() {
                    return BuiltResponse.this.status;
                }

                @Override
                public Response.Status.Family getFamily() {
                    return Response.Status.Family.familyOf(BuiltResponse.this.status);
                }

                @Override
                public String getReasonPhrase() {
                    return "Unknown Code";
                }
            };
        }
        return statusType;
    }

    @Override
    public MultivaluedMap<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setEntity(Object entity) {
        if (entity == null) {
            this.entity = null;
            this.genericType = null;
            this.entityClass = null;
        } else if (entity instanceof GenericEntity) {
            GenericEntity ge = (GenericEntity)entity;
            this.entity = ge.getEntity();
            this.genericType = ge.getType();
            this.entityClass = ge.getRawType();
        } else {
            this.entity = entity;
            this.entityClass = entity.getClass();
            this.genericType = null;
        }
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setMetadata(MultivaluedMap<String, Object> metadata) {
        this.metadata = new Headers();
        this.metadata.putAll(metadata);
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public void addMethodAnnotations(Method method) {
        ArrayList<Annotation> ann = new ArrayList<Annotation>();
        if (this.annotations != null) {
            for (Annotation annotation : this.annotations) {
                ann.add(annotation);
            }
        }
        for (Annotation annotation : method.getAnnotations()) {
            ann.add(annotation);
        }
        this.annotations = ann.toArray(new Annotation[ann.size()]);
    }

    public void setAnnotations(Annotation[] annotations) {
        this.annotations = annotations;
    }

    public Type getGenericType() {
        return this.genericType;
    }

    public void setGenericType(Type genericType) {
        this.genericType = genericType;
    }

    @Override
    public <T> T readEntity(Class<T> type, Annotation[] annotations) {
        return this.readEntity(type, null, annotations);
    }

    @Override
    public <T> T readEntity(GenericType<T> entityType, Annotation[] annotations) {
        return (T)this.readEntity(entityType.getRawType(), entityType.getType(), annotations);
    }

    @Override
    public <T> T readEntity(Class<T> type) {
        return this.readEntity(type, null, null);
    }

    @Override
    public <T> T readEntity(GenericType<T> entityType) {
        return (T)this.readEntity(entityType.getRawType(), entityType.getType(), null);
    }

    public <T> T readEntity(Class<T> type, Type genericType, Annotation[] anns) {
        throw new IllegalStateException("Entity is not backed by an input stream");
    }

    @Override
    public boolean hasEntity() {
        this.abortIfClosed();
        return this.entity != null;
    }

    @Override
    public boolean bufferEntity() {
        this.abortIfClosed();
        return false;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void abortIfClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("Response is closed.");
        }
    }

    @Override
    public void close() {
        this.isClosed = true;
    }

    @Override
    public Locale getLanguage() {
        Object obj = this.metadata.getFirst("Content-Language");
        if (obj == null) {
            return null;
        }
        if (obj instanceof Locale) {
            return (Locale)obj;
        }
        return new LocaleDelegate().fromString(this.toHeaderString(obj));
    }

    @Override
    public int getLength() {
        Object obj = this.metadata.getFirst("Content-Length");
        if (obj == null) {
            return -1;
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        return Integer.valueOf(this.toHeaderString(obj));
    }

    @Override
    public MediaType getMediaType() {
        Object obj = this.metadata.getFirst("Content-Type");
        if (obj instanceof MediaType) {
            return (MediaType)obj;
        }
        if (obj == null) {
            return null;
        }
        return MediaType.valueOf(this.toHeaderString(obj));
    }

    @Override
    public Map<String, NewCookie> getCookies() {
        HashMap<String, NewCookie> cookies = new HashMap<String, NewCookie>();
        Object list = this.metadata.get("Set-Cookie");
        if (list == null) {
            return cookies;
        }
        Iterator i$ = list.iterator();
        while (i$.hasNext()) {
            Object obj = i$.next();
            if (obj instanceof NewCookie) {
                NewCookie cookie = (NewCookie)obj;
                cookies.put(cookie.getName(), cookie);
                continue;
            }
            String str = this.toHeaderString(obj);
            NewCookie cookie = NewCookie.valueOf(str);
            cookies.put(cookie.getName(), cookie);
        }
        return cookies;
    }

    @Override
    public EntityTag getEntityTag() {
        Object d = this.metadata.getFirst("ETag");
        if (d == null) {
            return null;
        }
        if (d instanceof EntityTag) {
            return (EntityTag)d;
        }
        return EntityTag.valueOf(this.toHeaderString(d));
    }

    @Override
    public Date getDate() {
        Object d = this.metadata.getFirst("Date");
        if (d == null) {
            return null;
        }
        if (d instanceof Date) {
            return (Date)d;
        }
        return DateUtil.parseDate(d.toString());
    }

    @Override
    public Date getLastModified() {
        Object d = this.metadata.getFirst("Last-Modified");
        if (d == null) {
            return null;
        }
        if (d instanceof Date) {
            return (Date)d;
        }
        return DateUtil.parseDate(d.toString());
    }

    @Override
    public Set<String> getAllowedMethods() {
        HashSet<String> allowedMethods = new HashSet<String>();
        Object allowed = this.metadata.get("Allow");
        if (allowed == null) {
            return allowedMethods;
        }
        Iterator i$ = allowed.iterator();
        while (i$.hasNext()) {
            Object header = i$.next();
            if (header != null && header instanceof String) {
                String[] list;
                for (String str : list = ((String)header).split(",")) {
                    if ("".equals(str.trim())) continue;
                    allowedMethods.add(str.trim().toUpperCase());
                }
                continue;
            }
            allowedMethods.add(this.toHeaderString(header).toUpperCase());
        }
        return allowedMethods;
    }

    protected String toHeaderString(Object header) {
        if (header instanceof String) {
            return (String)header;
        }
        return this.getHeaderValueProcessor().toHeaderString(header);
    }

    @Override
    public MultivaluedMap<String, String> getStringHeaders() {
        CaseInsensitiveMap<String> map = new CaseInsensitiveMap<String>();
        for (Map.Entry entry : this.metadata.entrySet()) {
            for (Object obj : entry.getValue()) {
                map.add(entry.getKey(), this.toHeaderString(obj));
            }
        }
        return map;
    }

    @Override
    public String getHeaderString(String name) {
        Object vals = this.metadata.get(name);
        if (vals == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        Iterator i$ = vals.iterator();
        while (i$.hasNext()) {
            Object val = i$.next();
            if (first) {
                first = false;
            } else {
                builder.append(",");
            }
            val = this.toHeaderString(val);
            if (val == null) {
                val = "";
            }
            builder.append(val);
        }
        return builder.toString();
    }

    @Override
    public URI getLocation() {
        Object uri = this.metadata.getFirst("Location");
        if (uri == null) {
            return null;
        }
        if (uri instanceof URI) {
            return (URI)uri;
        }
        String str = null;
        str = uri instanceof String ? (String)uri : this.toHeaderString(uri);
        return URI.create(str);
    }

    @Override
    public Set<Link> getLinks() {
        LinkHeaders linkHeaders = this.getLinkHeaders();
        HashSet<Link> links = new HashSet<Link>();
        links.addAll(linkHeaders.getLinks());
        return links;
    }

    protected LinkHeaders getLinkHeaders() {
        LinkHeaders linkHeaders = new LinkHeaders();
        linkHeaders.addLinkObjects(this.metadata, this.getHeaderValueProcessor());
        return linkHeaders;
    }

    @Override
    public boolean hasLink(String relation) {
        return this.getLinkHeaders().getLinkByRelationship(relation) != null;
    }

    @Override
    public Link getLink(String relation) {
        return this.getLinkHeaders().getLinkByRelationship(relation);
    }

    @Override
    public Link.Builder getLinkBuilder(String relation) {
        Link link = this.getLinkHeaders().getLinkByRelationship(relation);
        if (link == null) {
            return null;
        }
        return Link.fromLink(link);
    }
}

