/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.client.jaxrs.ProxyConfig;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.internal.proxy.ClientInvoker;
import org.jboss.resteasy.client.jaxrs.internal.proxy.ClientProxy;
import org.jboss.resteasy.client.jaxrs.internal.proxy.MethodInvoker;
import org.jboss.resteasy.client.jaxrs.internal.proxy.SubResourceInvoker;
import org.jboss.resteasy.util.IsHttpMethod;

public class ProxyBuilder<T> {
    private final Class<T> iface;
    private final ResteasyWebTarget webTarget;
    private ClassLoader loader = Thread.currentThread().getContextClassLoader();
    private MediaType serverConsumes;
    private MediaType serverProduces;

    public static <T> ProxyBuilder<T> builder(Class<T> iface, WebTarget webTarget) {
        return new ProxyBuilder<T>(iface, (ResteasyWebTarget)webTarget);
    }

    public static <T> T proxy(Class<T> iface, WebTarget base, ProxyConfig config) {
        Path path;
        if (iface.isAnnotationPresent(Path.class) && !(path = iface.getAnnotation(Path.class)).value().equals("") && !path.value().equals("/")) {
            base = base.path(path.value());
        }
        HashMap<Method, MethodInvoker> methodMap = new HashMap<Method, MethodInvoker>();
        for (Method method : iface.getMethods()) {
            Set<String> httpMethods = IsHttpMethod.getHttpMethods(method);
            MethodInvoker invoker = (httpMethods == null || httpMethods.size() == 0) && method.isAnnotationPresent(Path.class) && method.getReturnType().isInterface() ? new SubResourceInvoker((ResteasyWebTarget)base, method, config) : ProxyBuilder.createClientInvoker(iface, method, (ResteasyWebTarget)base, config);
            methodMap.put(method, invoker);
        }
        Class[] intfs = new Class[]{iface};
        ClientProxy clientProxy = new ClientProxy(methodMap);
        clientProxy.setClazz(iface);
        return (T)Proxy.newProxyInstance(config.getLoader(), intfs, (InvocationHandler)clientProxy);
    }

    private static <T> ClientInvoker createClientInvoker(Class<T> clazz, Method method, ResteasyWebTarget base, ProxyConfig config) {
        Set<String> httpMethods = IsHttpMethod.getHttpMethods(method);
        if (httpMethods == null || httpMethods.size() != 1) {
            throw new RuntimeException("You must use at least one, but no more than one http method annotation on: " + method.toString());
        }
        ClientInvoker invoker = new ClientInvoker(base, clazz, method, config);
        invoker.setHttpMethod(httpMethods.iterator().next());
        return invoker;
    }

    private ProxyBuilder(Class<T> iface, ResteasyWebTarget webTarget) {
        this.iface = iface;
        this.webTarget = webTarget;
    }

    public ProxyBuilder<T> classloader(ClassLoader cl) {
        this.loader = cl;
        return this;
    }

    public ProxyBuilder<T> defaultProduces(MediaType type) {
        this.serverProduces = type;
        return this;
    }

    public ProxyBuilder<T> defaultConsumes(MediaType type) {
        this.serverConsumes = type;
        return this;
    }

    public ProxyBuilder<T> defaultProduces(String type) {
        this.serverProduces = MediaType.valueOf(type);
        return this;
    }

    public ProxyBuilder<T> defaultConsumes(String type) {
        this.serverConsumes = MediaType.valueOf(type);
        return this;
    }

    public T build() {
        return ProxyBuilder.proxy(this.iface, this.webTarget, new ProxyConfig(this.loader, this.serverConsumes, this.serverProduces));
    }
}

