/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfiguration;
import org.jboss.resteasy.client.jaxrs.internal.ClientResponse;
import org.jboss.resteasy.specimpl.BuiltResponse;

public class AbortedResponse
extends ClientResponse {
    protected InputStream is;

    public AbortedResponse(ClientConfiguration configuration, Response response) {
        super(configuration);
        for (Map.Entry entry : response.getMetadata().entrySet()) {
            for (Object obj : (List)entry.getValue()) {
                this.getMetadata().add((String)entry.getKey(), configuration.toHeaderString(obj));
            }
        }
        this.setStatus(response.getStatus());
        this.setEntity(response.getEntity());
        if (response instanceof BuiltResponse) {
            BuiltResponse built = (BuiltResponse)response;
            this.setEntityClass(built.getEntityClass());
            this.setGenericType(built.getGenericType());
            this.setAnnotations(built.getAnnotations());
        }
        if (response.getEntity() != null) {
            MediaType mediaType = this.getMediaType();
            if (mediaType == null) {
                mediaType = MediaType.WILDCARD_TYPE;
                this.getHeaders().putSingle("Content-Type", "*/*");
            }
            if (!(response.getEntity() instanceof InputStream)) {
                MessageBodyWriter<Object> writer = configuration.getMessageBodyWriter(this.getEntityClass(), this.getGenericType(), null, mediaType);
                if (writer == null) {
                    throw new ProcessingException("Failed to buffer aborted response. Could not find writer for content-type " + mediaType + " type: " + this.entityClass.getName());
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    writer.writeTo(this.getEntity(), this.getEntityClass(), this.getGenericType(), this.getAnnotations(), mediaType, this.getHeaders(), baos);
                }
                catch (IOException e) {
                    throw new ProcessingException("Failed to buffer aborted response", e);
                }
                this.bufferedEntity = baos.toByteArray();
                this.setInputStream(new ByteArrayInputStream(this.bufferedEntity));
            } else {
                InputStream is = (InputStream)response.getEntity();
                this.setInputStream(is);
            }
            this.setEntity(null);
            this.setAnnotations(null);
        }
    }

    @Override
    protected InputStream getInputStream() {
        if (this.is == null && this.entity != null && this.entity instanceof InputStream) {
            this.is = (InputStream)this.entity;
        }
        return this.is;
    }

    @Override
    protected void setInputStream(InputStream is) {
        this.is = is;
    }

    @Override
    protected void releaseConnection() {
        try {
            if (this.is != null) {
                this.is.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

