/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service;

import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.Validatable;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.api.scr.ValidationSupport;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.jboss.gravia.utils.IllegalStateAssertion;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerService;

@ThreadSafe
@Component(name="io.fabric8.profile.urlhandler", label="Fabric8 Profile URL Handler", immediate=true, metatype=false)
@Service(value={URLStreamHandlerService.class})
@Properties(value={@Property(name="url.handler.protocol", value={"profile"})})
public final class ProfileUrlHandler
extends AbstractURLStreamHandlerService
implements Validatable {
    private static final String SYNTAX = "profile:<resource name>";
    @Reference(referenceInterface=FabricService.class)
    private final ValidatingReference<FabricService> fabricService = new ValidatingReference();
    private final ValidationSupport active = new ValidationSupport();

    @Activate
    void activate() {
        this.active.setValid();
    }

    @Deactivate
    void deactivate() {
        this.active.setInvalid();
    }

    public boolean isValid() {
        return this.active.isValid();
    }

    public void assertValid() {
        this.active.assertValid();
    }

    public URLConnection openConnection(URL url) throws IOException {
        this.assertValid();
        return new Connection(url);
    }

    void bindFabricService(FabricService fabricService) {
        this.fabricService.bind((Object)fabricService);
    }

    void unbindFabricService(FabricService fabricService) {
        this.fabricService.unbind((Object)fabricService);
    }

    private class Connection
    extends URLConnection {
        public Connection(URL url) throws MalformedURLException {
            super(url);
            if (url.getPath() == null || url.getPath().trim().length() == 0) {
                throw new MalformedURLException("Path can not be null or empty. Syntax: profile:<resource name>");
            }
            if (url.getHost() != null && url.getHost().length() > 0 || url.getPort() != -1) {
                throw new MalformedURLException("Unsupported host/port in profile url");
            }
            if (url.getQuery() != null && url.getQuery().length() > 0) {
                throw new MalformedURLException("Unsupported query in profile url");
            }
        }

        @Override
        public void connect() throws IOException {
            ProfileUrlHandler.this.assertValid();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            ProfileUrlHandler.this.assertValid();
            String path = this.url.getPath();
            Container container = ((FabricService)ProfileUrlHandler.this.fabricService.get()).getCurrentContainer();
            Profile overlayProfile = container.getOverlayProfile();
            byte[] bytes = overlayProfile.getFileConfiguration(path);
            IllegalStateAssertion.assertNotNull((Object)bytes, (String)("Resource " + path + " does not exist in the profile overlay."));
            return new ByteArrayInputStream(bytes);
        }
    }
}

