/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service;

import com.google.common.base.Charsets;
import com.google.common.io.Closeables;
import io.fabric8.api.FabricService;
import io.fabric8.api.MQService;
import io.fabric8.api.Profile;
import io.fabric8.api.ProfileBuilder;
import io.fabric8.api.ProfileRegistry;
import io.fabric8.api.ProfileService;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.Version;
import io.fabric8.common.util.Files;
import io.fabric8.common.util.Strings;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQServiceImpl
implements MQService {
    private static final transient Logger LOG = LoggerFactory.getLogger(MQServiceImpl.class);
    private final ProfileService profileService;
    private final ProfileRegistry profileRegistry;
    private final RuntimeProperties runtimeProperties;

    public MQServiceImpl(FabricService fabricService, RuntimeProperties runtimeProperties) {
        this.profileService = (ProfileService)fabricService.adapt(ProfileService.class);
        this.profileRegistry = (ProfileRegistry)fabricService.adapt(ProfileRegistry.class);
        this.runtimeProperties = runtimeProperties;
    }

    public Profile createOrUpdateMQProfile(String versionId, String profileId, String brokerName, Map<String, String> configs, boolean replicated) {
        String[] propertiesToDefault;
        ProfileBuilder builder;
        boolean create;
        Version version = this.profileService.getRequiredVersion(versionId);
        String parentProfileName = null;
        if (configs != null && configs.containsKey("parent")) {
            parentProfileName = configs.remove("parent");
        }
        if (Strings.isNullOrBlank(parentProfileName)) {
            parentProfileName = replicated ? "mq-replicated" : "mq-base";
        }
        Profile parentProfile = version.getRequiredProfile(parentProfileName);
        if (brokerName == null || profileId == null) {
            return parentProfile;
        }
        String pidName = this.getBrokerPID(brokerName);
        HashMap<String, String> config = null;
        boolean bl = create = !version.hasProfile(profileId);
        if (create) {
            builder = ProfileBuilder.Factory.create((String)versionId, (String)profileId);
        } else {
            Profile profile = version.getRequiredProfile(profileId);
            builder = ProfileBuilder.Factory.createFrom((Profile)profile);
            config = new HashMap<String, String>(builder.getConfiguration(pidName));
        }
        Map parentProfileConfig = parentProfile.getConfiguration("io.fabric8.mq.fabric.template");
        if (config == null) {
            config = new HashMap(parentProfileConfig);
        }
        if ("true".equals(configs.get("ssl"))) {
            byte[] truststore;
            File keystoreFile;
            String password;
            byte[] keystore = builder.getFileConfiguration("keystore.jks");
            if (keystore == null) {
                try {
                    String host = configs.get("keystore.cn");
                    if (host == null) {
                        host = configs.get("group");
                        if (host == null) {
                            host = "localhost";
                        }
                        configs.put("keystore.cn", host);
                    }
                    if ((password = configs.get("keystore.password")) == null) {
                        password = MQServiceImpl.generatePassword(8);
                        configs.put("keystore.password", password);
                    }
                    keystoreFile = io.fabric8.utils.Files.createTempFile(this.runtimeProperties.getDataPath());
                    keystoreFile.delete();
                    LOG.info("Generating ssl keystore...");
                    int rc = this.system("keytool", "-genkey", "-storetype", "JKS", "-storepass", password, "-keystore", keystoreFile.getCanonicalPath(), "-keypass", password, "-alias", host, "-keyalg", "RSA", "-keysize", "4096", "-dname", String.format("cn=%s", host), "-validity", "3650");
                    if (rc != 0) {
                        throw new IOException("keytool failed with exit code: " + rc);
                    }
                    keystore = Files.readBytes((File)keystoreFile);
                    keystoreFile.delete();
                    LOG.info("Keystore generated");
                    builder.addFileConfiguration("keystore.jks", keystore);
                    configs.put("keystore.file", "profile:keystore.jks");
                }
                catch (IOException e) {
                    LOG.info("Failed to generate keystore.jks: " + e, (Throwable)e);
                }
            }
            if ((truststore = builder.getFileConfiguration("truststore.jks")) == null) {
                try {
                    password = configs.get("truststore.password");
                    if (password == null) {
                        password = configs.get("keystore.password");
                        configs.put("truststore.password", password);
                    }
                    keystoreFile = io.fabric8.utils.Files.createTempFile(this.runtimeProperties.getDataPath());
                    Files.writeToFile((File)keystoreFile, (byte[])keystore);
                    File certFile = io.fabric8.utils.Files.createTempFile(this.runtimeProperties.getDataPath());
                    certFile.delete();
                    LOG.info("Exporting broker certificate to create truststore.jks");
                    int rc = this.system("keytool", "-exportcert", "-rfc", "-keystore", keystoreFile.getCanonicalPath(), "-storepass", configs.get("keystore.password"), "-alias", configs.get("keystore.cn"), "--file", certFile.getCanonicalPath());
                    keystoreFile.delete();
                    if (rc != 0) {
                        throw new IOException("keytool failed with exit code: " + rc);
                    }
                    LOG.info("Creating truststore.jks");
                    File truststoreFile = io.fabric8.utils.Files.createTempFile(this.runtimeProperties.getDataPath());
                    truststoreFile.delete();
                    rc = this.system("keytool", "-importcert", "-noprompt", "-keystore", truststoreFile.getCanonicalPath(), "-storepass", password, "--file", certFile.getCanonicalPath());
                    certFile.delete();
                    if (rc != 0) {
                        throw new IOException("keytool failed with exit code: " + rc);
                    }
                    truststore = Files.readBytes((File)truststoreFile);
                    truststoreFile.delete();
                    builder.addFileConfiguration("truststore.jks", truststore);
                    configs.put("truststore.file", "profile:truststore.jks");
                }
                catch (IOException e) {
                    LOG.info("Failed to generate truststore.jks: " + e, (Throwable)e);
                }
            }
        }
        config.put("broker-name", brokerName);
        if (configs != null) {
            config.putAll(configs);
        }
        for (String key : propertiesToDefault = new String[]{"config", "standby.pool", "connectors"}) {
            String defaultValue;
            if (config.get(key) != null || !Strings.isNotBlank((String)(defaultValue = (String)parentProfileConfig.get(key)))) continue;
            config.put(key, defaultValue);
        }
        builder.addConfiguration(pidName, config);
        Profile profile = builder.getProfile();
        return create ? this.profileService.createProfile(profile) : this.profileService.updateProfile(profile);
    }

    public static String generatePassword(int len) {
        Random random = new Random(System.nanoTime());
        String characters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890_-!.+^";
        StringBuilder rc = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            rc.append(characters.charAt(random.nextInt(characters.length())));
        }
        return rc.toString();
    }

    private int system(final String ... args) {
        Process process;
        ProcessBuilder processBuilder = new ProcessBuilder(args);
        processBuilder.redirectErrorStream(true);
        try {
            process = processBuilder.start();
        }
        catch (IOException e) {
            LOG.debug("Process failed to start: " + e, (Throwable)e);
            return -1;
        }
        new Thread("system command output processor"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                StringBuffer buffer = new StringBuffer();
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), Charsets.UTF_8));
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        LOG.info(String.format("%s: %s", args[0], line));
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    Closeables.closeQuietly((Closeable)reader);
                }
            }
        }.start();
        boolean exitCode = false;
        try {
            return process.waitFor();
        }
        catch (InterruptedException e) {
            LOG.debug("Thread interrupted, killing process");
            process.destroy();
            Thread.currentThread().interrupt();
            return -1;
        }
    }

    public Profile createOrUpdateMQClientProfile(String versionId, String profileId, String group, String parentProfileName) {
        HashMap<String, String> config;
        ProfileBuilder builder;
        boolean create;
        Version version = this.profileService.getRequiredVersion(versionId);
        Profile parentProfile = null;
        if (Strings.isNotBlank((String)parentProfileName)) {
            parentProfile = version.getRequiredProfile(parentProfileName);
        }
        if (group == null || profileId == null) {
            return parentProfile;
        }
        boolean bl = create = !version.hasProfile(profileId);
        if (create) {
            builder = ProfileBuilder.Factory.create((String)versionId, (String)profileId);
        } else {
            Profile profile = version.getRequiredProfile(profileId);
            builder = ProfileBuilder.Factory.createFrom((Profile)profile);
        }
        if (parentProfile != null) {
            builder.addParent(parentProfile);
        }
        config = (config = builder.getConfiguration("io.fabric8.mq.fabric.cf")) != null ? new HashMap<String, String>(config) : new HashMap();
        config.put("group", group);
        builder.addConfiguration("io.fabric8.mq.fabric.cf", config);
        Profile profile = builder.getProfile();
        return create ? this.profileService.createProfile(profile) : this.profileService.updateProfile(profile);
    }

    public String getConfig(String version, String config) {
        return "profile:" + config;
    }

    protected String getBrokerPID(String brokerName) {
        return "io.fabric8.mq.fabric.server-" + brokerName;
    }
}

