/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.internal;

import io.fabric8.api.AbstractBuilder;
import io.fabric8.api.AttributableBuilder;
import io.fabric8.api.Builder;
import io.fabric8.api.OptionsProvider;
import io.fabric8.api.Profile;
import io.fabric8.api.ProfileBuilder;
import io.fabric8.internal.ProfileImpl;
import io.fabric8.utils.DataStoreUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.gravia.utils.IllegalStateAssertion;

final class DefaultProfileBuilder
extends AbstractBuilder<ProfileBuilder>
implements AttributableBuilder<ProfileBuilder>,
ProfileBuilder {
    private static final String PARENTS_ATTRIBUTE_KEY = "attribute.parents";
    private static final String LOCKED_ATTRIBUTE_KEY = "attribute.locked";
    private String versionId;
    private String profileId;
    private Map<String, Profile> parentMapping = new LinkedHashMap<String, Profile>();
    private Map<String, byte[]> fileMapping = new HashMap<String, byte[]>();
    private String lastModified;
    private boolean isOverlay;

    DefaultProfileBuilder(String versionId, String profileId) {
        this.versionId = versionId;
        this.profileId = profileId;
    }

    DefaultProfileBuilder(Profile profile) {
        this.versionId = profile.getVersion();
        this.profileId = profile.getId();
        this.addParents(profile.getParents());
        this.setFileConfigurations(profile.getFileConfigurations());
        this.lastModified = null;
    }

    public ProfileBuilder addOptions(OptionsProvider<ProfileBuilder> optionsProvider) {
        return (ProfileBuilder)optionsProvider.addOptions((Builder)this);
    }

    public ProfileBuilder identity(String profileId) {
        this.profileId = profileId;
        return this;
    }

    public ProfileBuilder version(String versionId) {
        this.versionId = versionId;
        return this;
    }

    public ProfileBuilder addParent(Profile profile) {
        this.parentMapping.put(profile.getId(), profile);
        this.updateParentsAttribute();
        return this;
    }

    public ProfileBuilder addParents(List<Profile> profiles) {
        return this.addParentsInternal(profiles, false);
    }

    public List<String> getParents() {
        return Collections.unmodifiableList(new ArrayList<String>(this.parentMapping.keySet()));
    }

    public Profile getParent(String profileId) {
        return this.parentMapping.get(profileId);
    }

    public ProfileBuilder setParents(List<Profile> profiles) {
        return this.addParentsInternal(profiles, true);
    }

    private ProfileBuilder addParentsInternal(List<Profile> profiles, boolean clear) {
        if (clear) {
            this.parentMapping.clear();
        }
        for (Profile profile : profiles) {
            this.parentMapping.put(profile.getId(), profile);
        }
        this.updateParentsAttribute();
        return this;
    }

    public ProfileBuilder removeParent(String profileId) {
        this.parentMapping.remove(profileId);
        this.updateParentsAttribute();
        return this;
    }

    private void updateParentsAttribute() {
        Map<String, String> config = this.getConfigurationInternal("io.fabric8.agent");
        config.remove(PARENTS_ATTRIBUTE_KEY);
        if (this.parentMapping.size() > 0) {
            config.put(PARENTS_ATTRIBUTE_KEY, this.parentsAttributeValue());
        }
        this.addConfiguration("io.fabric8.agent", config);
    }

    private String parentsAttributeValue() {
        String pspec = "";
        if (this.parentMapping.size() > 0) {
            for (String parentId : this.parentMapping.keySet()) {
                pspec = pspec + " " + parentId;
            }
            pspec = pspec.substring(1);
        }
        return pspec;
    }

    public ProfileBuilder setLocked(boolean flag) {
        Map<String, String> config = this.getConfigurationInternal("io.fabric8.agent");
        if (flag) {
            config.put(LOCKED_ATTRIBUTE_KEY, "true");
        } else {
            config.remove(LOCKED_ATTRIBUTE_KEY);
        }
        this.addConfiguration("io.fabric8.agent", config);
        return this;
    }

    public Set<String> getFileConfigurationKeys() {
        return this.fileMapping.keySet();
    }

    public byte[] getFileConfiguration(String key) {
        return this.fileMapping.get(key);
    }

    public ProfileBuilder setFileConfigurations(Map<String, byte[]> configurations) {
        this.fileMapping = new HashMap<String, byte[]>(configurations);
        return this;
    }

    public ProfileBuilder addFileConfiguration(String fileName, byte[] data) {
        this.fileMapping.put(fileName, data);
        return this;
    }

    public ProfileBuilder deleteFileConfiguration(String fileName) {
        this.fileMapping.remove(fileName);
        return this;
    }

    public ProfileBuilder setConfigurations(Map<String, Map<String, String>> configs) {
        for (String string : this.getConfigurationKeys()) {
            this.deleteConfiguration(string);
        }
        for (Map.Entry entry : configs.entrySet()) {
            this.addConfiguration((String)entry.getKey(), new HashMap<String, String>((Map)entry.getValue()));
        }
        return this;
    }

    public ProfileBuilder addConfiguration(String pid, Map<String, String> config) {
        this.fileMapping.put(pid + ".properties", DataStoreUtils.toBytes(config));
        return this;
    }

    public ProfileBuilder addConfiguration(String pid, String key, String value) {
        Map<String, String> config = this.getConfigurationInternal(pid);
        config.put(key, value);
        return this.addConfiguration(pid, config);
    }

    public Set<String> getConfigurationKeys() {
        HashSet<String> result = new HashSet<String>();
        for (String fileKey : this.fileMapping.keySet()) {
            if (!fileKey.endsWith(".properties")) continue;
            String configKey = fileKey.substring(0, fileKey.indexOf(".properties"));
            result.add(configKey);
        }
        return Collections.unmodifiableSet(result);
    }

    public Map<String, String> getConfiguration(String pid) {
        Map<String, String> config = this.getConfigurationInternal(pid);
        return Collections.unmodifiableMap(config);
    }

    private Map<String, String> getConfigurationInternal(String pid) {
        byte[] bytes = this.fileMapping.get(pid + ".properties");
        return new HashMap<String, String>(DataStoreUtils.toMap(bytes));
    }

    public ProfileBuilder deleteConfiguration(String pid) {
        this.fileMapping.remove(pid + ".properties");
        return this;
    }

    public ProfileBuilder setBundles(List<String> values) {
        this.addAgentConfiguration(ProfileImpl.ConfigListType.BUNDLES, values);
        return this;
    }

    public ProfileBuilder setFabs(List<String> values) {
        this.addAgentConfiguration(ProfileImpl.ConfigListType.FABS, values);
        return this;
    }

    public ProfileBuilder setFeatures(List<String> values) {
        this.addAgentConfiguration(ProfileImpl.ConfigListType.FEATURES, values);
        return this;
    }

    public ProfileBuilder setRepositories(List<String> values) {
        this.addAgentConfiguration(ProfileImpl.ConfigListType.BUNDLES, values);
        return this;
    }

    public ProfileBuilder setOverrides(List<String> values) {
        this.addAgentConfiguration(ProfileImpl.ConfigListType.OVERRIDES, values);
        return this;
    }

    public ProfileBuilder setOptionals(List<String> values) {
        this.addAgentConfiguration(ProfileImpl.ConfigListType.OPTIONALS, values);
        return this;
    }

    public ProfileBuilder setTags(List<String> values) {
        this.addAgentConfiguration(ProfileImpl.ConfigListType.TAGS, values);
        return this;
    }

    public ProfileBuilder setOverlay(boolean overlay) {
        this.isOverlay = overlay;
        return this;
    }

    public ProfileBuilder setLastModified(String lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    public ProfileBuilder addAttribute(String key, String value) {
        this.addConfiguration("io.fabric8.agent", "attribute." + key, value);
        return this;
    }

    public ProfileBuilder setAttributes(Map<String, String> attributes) {
        Map<String, String> config = this.getConfigurationInternal("io.fabric8.agent");
        for (String string : new ArrayList<String>(config.keySet())) {
            if (!string.startsWith("attribute.")) continue;
            config.remove(string);
        }
        for (Map.Entry entry : attributes.entrySet()) {
            config.put("attribute." + (String)entry.getKey(), (String)entry.getValue());
        }
        this.addConfiguration("io.fabric8.agent", config);
        return null;
    }

    private void addAgentConfiguration(ProfileImpl.ConfigListType type, List<String> values) {
        String prefix = (Object)((Object)type) + ".";
        Map<String, String> config = this.getConfigurationInternal("io.fabric8.agent");
        for (String key : new ArrayList<String>(config.keySet())) {
            if (!key.startsWith(prefix)) continue;
            config.remove(key);
        }
        for (String value : values) {
            config.put(prefix + value, value);
        }
        this.addConfiguration("io.fabric8.agent", config);
    }

    protected void validate() {
        super.validate();
        IllegalStateAssertion.assertNotNull((Object)this.profileId, (String)"Profile must have an identity");
        IllegalStateAssertion.assertNotNull((Object)this.versionId, (String)"Version must be specified");
        for (Profile parent : this.parentMapping.values()) {
            String parentVersion = parent.getVersion();
            IllegalStateAssertion.assertEquals((Object)this.versionId, (Object)parentVersion, (String)("Profile version not '" + this.versionId + "' for: " + parent));
        }
    }

    public Profile getProfile() {
        this.validate();
        ArrayList<Profile> parents = new ArrayList<Profile>(this.parentMapping.values());
        return new ProfileImpl(this.versionId, this.profileId, parents, this.fileMapping, this.lastModified, this.isOverlay);
    }
}

