/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class OsgiUtils {
    public static final Long SERVICE_TIMEOUT = 20000L;

    public void waitForSerice(Class type, long timeout) {
        OsgiUtils.waitForSerice(type, null, timeout);
    }

    public static void waitForSerice(Class type) {
        OsgiUtils.waitForSerice(type, null, SERVICE_TIMEOUT);
    }

    public static void waitForSerice(Class type, String filter, long timeout) {
        BundleContext bundleContext = OsgiUtils.getBundleContext();
        ServiceTracker tracker = null;
        try {
            String flt = filter != null ? (filter.startsWith("(") ? "(&(objectClass=" + type.getName() + ")" + filter + ")" : "(&(objectClass=" + type.getName() + ")(" + filter + "))") : "(objectClass=" + type.getName() + ")";
            Filter osgiFilter = FrameworkUtil.createFilter((String)flt);
            tracker = new ServiceTracker(bundleContext, osgiFilter, null);
            tracker.open(true);
            if (tracker.waitForService(timeout) == null) {
                throw new RuntimeException("Gave up waiting for service " + flt);
            }
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Invalid filter", e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            tracker.close();
        }
    }

    private static BundleContext getBundleContext() {
        return FrameworkUtil.getBundle(OsgiUtils.class).getBundleContext();
    }

    private static String explode(Dictionary dictionary) {
        Enumeration keys = dictionary.keys();
        StringBuffer result = new StringBuffer();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            result.append(String.format("%s=%s", key, dictionary.get(key)));
            if (!keys.hasMoreElements()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    private static Collection<ServiceReference> asCollection(ServiceReference[] references) {
        return references != null ? Arrays.asList(references) : Collections.emptyList();
    }
}

