/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service.jclouds.modules;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.Validatable;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.api.scr.ValidationSupport;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.karaf.core.CredentialStore;
import org.jclouds.rest.ConfiguresCredentialStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@ConfiguresCredentialStore
@Component(name="io.fabric8.jclouds.credential.store.zookeeper", label="Fabric8 Jclouds ZooKeeper Credential Store", immediate=true, metatype=false)
@Service(value={CredentialStore.class, ConnectionStateListener.class})
public final class ZookeeperCredentialStore
extends CredentialStore
implements ConnectionStateListener,
Validatable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperCredentialStore.class);
    @Reference(referenceInterface=CuratorFramework.class)
    private final ValidatingReference<CuratorFramework> curator = new ValidatingReference();
    private final Cache<String, Credentials> cache = CacheBuilder.newBuilder().maximumSize(100L).build();
    private final ValidationSupport active = new ValidationSupport();
    private final Object storeLock = new Object();

    @Activate
    void activate() {
        this.setStore(new ZookeeperBacking((CuratorFramework)this.curator.get(), this.cache));
        this.active.setValid();
    }

    @Deactivate
    void deactivate() {
        this.active.setInvalid();
        this.cache.cleanUp();
    }

    public boolean isValid() {
        return this.active.isValid();
    }

    public void assertValid() {
        this.active.assertValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Credentials> getStore() {
        Object object = this.storeLock;
        synchronized (object) {
            return super.getStore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStore(Map<String, Credentials> store) {
        Object object = this.storeLock;
        synchronized (object) {
            super.setStore(store);
        }
    }

    public void stateChanged(CuratorFramework client, ConnectionState newState) {
        if (this.isValid()) {
            switch (newState) {
                case CONNECTED: 
                case RECONNECTED: {
                    this.curator.bind((Object)client);
                    this.onConnected();
                    break;
                }
                default: {
                    this.onDisconnected();
                }
            }
        }
    }

    private void onConnected() {
        for (Map.Entry entry : this.cache.asMap().entrySet()) {
            String s = (String)entry.getKey();
            Credentials credentials = (Credentials)entry.getValue();
            this.getStore().put(s, credentials);
        }
    }

    private void onDisconnected() {
    }

    void bindCurator(CuratorFramework curator) {
        this.curator.bind((Object)curator);
    }

    void unbindCurator(CuratorFramework curator) {
        this.curator.unbind((Object)curator);
    }

    private static String normalizeKey(Object key) {
        String result = String.valueOf(key);
        return result.replaceAll("node#", "").replaceAll("#", "");
    }

    private static class CredentialsEntry
    implements Map.Entry<String, Credentials> {
        private final String key;
        private final CuratorFramework curator;

        private CredentialsEntry(CuratorFramework curator, String key) {
            this.curator = curator;
            this.key = key;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Credentials getValue() {
            LoginCredentials credentials = null;
            try {
                String identity = ZooKeeperUtils.getStringData((CuratorFramework)this.curator, (String)ZkPath.CLOUD_NODE_IDENTITY.getPath(new String[]{ZookeeperCredentialStore.normalizeKey(this.key)}));
                String credential = ZooKeeperUtils.getStringData((CuratorFramework)this.curator, (String)ZkPath.CLOUD_NODE_CREDENTIAL.getPath(new String[]{ZookeeperCredentialStore.normalizeKey(this.key)}));
                credentials = LoginCredentials.fromCredentials((Credentials)new Credentials(identity, credential));
            }
            catch (Exception e) {
                LOGGER.debug("Failed to read jclouds credentials from zookeeper due to {}.", (Object)e.getMessage());
            }
            return credentials;
        }

        @Override
        public Credentials setValue(Credentials credentials) {
            try {
                ZooKeeperUtils.setData((CuratorFramework)this.curator, (String)ZkPath.CLOUD_NODE_IDENTITY.getPath(new String[]{ZookeeperCredentialStore.normalizeKey(this.key)}), (String)credentials.identity);
                ZooKeeperUtils.setData((CuratorFramework)this.curator, (String)ZkPath.CLOUD_NODE_CREDENTIAL.getPath(new String[]{ZookeeperCredentialStore.normalizeKey(this.key)}), (String)credentials.credential);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to store jclouds credentials to zookeeper.", (Throwable)e);
            }
            return credentials;
        }
    }

    @ThreadSafe
    private static final class ZookeeperBacking
    implements Map<String, Credentials> {
        private final CuratorFramework curator;
        private final Cache<String, Credentials> cache;

        private ZookeeperBacking(CuratorFramework curator, Cache<String, Credentials> cache) {
            this.curator = curator;
            this.cache = cache;
        }

        @Override
        public synchronized int size() {
            int size = 0;
            try {
                if (ZooKeeperUtils.exists((CuratorFramework)this.curator, (String)ZkPath.CLOUD_NODES.getPath(new String[0])) != null) {
                    size = ZooKeeperUtils.getChildren((CuratorFramework)this.curator, (String)ZkPath.CLOUD_NODES.getPath(new String[0])).size();
                }
            }
            catch (Exception ex) {
                size = (int)this.cache.size();
            }
            return size;
        }

        @Override
        public synchronized boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public synchronized boolean containsKey(Object o) {
            boolean result = this.cache.asMap().containsKey(o);
            if (!result) {
                try {
                    result = ZooKeeperUtils.exists((CuratorFramework)this.curator, (String)ZkPath.CLOUD_NODE.getPath(new String[]{ZookeeperCredentialStore.normalizeKey(o)})) != null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return result;
        }

        @Override
        public synchronized boolean containsValue(Object o) {
            return false;
        }

        @Override
        public synchronized Credentials get(Object o) {
            Credentials credentials = (Credentials)this.cache.asMap().get(o);
            if (credentials == null) {
                try {
                    String identity = ZooKeeperUtils.getStringData((CuratorFramework)this.curator, (String)ZkPath.CLOUD_NODE_IDENTITY.getPath(new String[]{ZookeeperCredentialStore.normalizeKey(o)}));
                    String credential = ZooKeeperUtils.getStringData((CuratorFramework)this.curator, (String)ZkPath.CLOUD_NODE_CREDENTIAL.getPath(new String[]{ZookeeperCredentialStore.normalizeKey(o)}));
                    credentials = LoginCredentials.fromCredentials((Credentials)new Credentials(identity, credential));
                }
                catch (Exception e) {
                    LOGGER.debug("Failed to read jclouds credentials from zookeeper due to {}.", (Object)e.getMessage());
                }
            }
            return credentials;
        }

        @Override
        public synchronized Credentials put(String s, Credentials credentials) {
            this.cache.put((Object)s, (Object)credentials);
            try {
                ZooKeeperUtils.setData((CuratorFramework)this.curator, (String)ZkPath.CLOUD_NODE_IDENTITY.getPath(new String[]{ZookeeperCredentialStore.normalizeKey(s)}), (String)credentials.identity);
                ZooKeeperUtils.setData((CuratorFramework)this.curator, (String)ZkPath.CLOUD_NODE_CREDENTIAL.getPath(new String[]{ZookeeperCredentialStore.normalizeKey(s)}), (String)credentials.credential);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to store jclouds credentials to zookeeper.", (Throwable)e);
            }
            return credentials;
        }

        @Override
        public synchronized Credentials remove(Object o) {
            Credentials credentials = (Credentials)this.cache.asMap().remove(o);
            try {
                if (credentials == null) {
                    credentials = this.get(o);
                }
                String normalizedKey = ZookeeperCredentialStore.normalizeKey(o);
                ZooKeeperUtils.deleteSafe((CuratorFramework)this.curator, (String)ZkPath.CLOUD_NODE_IDENTITY.getPath(new String[]{normalizedKey}));
                ZooKeeperUtils.deleteSafe((CuratorFramework)this.curator, (String)ZkPath.CLOUD_NODE_CREDENTIAL.getPath(new String[]{normalizedKey}));
            }
            catch (Exception e) {
                LOGGER.warn("Failed to remove jclouds credentials to zookeeper.", (Throwable)e);
            }
            return credentials;
        }

        @Override
        public synchronized void putAll(Map<? extends String, ? extends Credentials> map) {
            for (Map.Entry<? extends String, ? extends Credentials> entry : map.entrySet()) {
                String s = entry.getKey();
                Credentials credential = entry.getValue();
                this.put(s, credential);
            }
        }

        @Override
        public synchronized void clear() {
            this.cache.cleanUp();
            try {
                for (String nodeId : this.keySet()) {
                    ZooKeeperUtils.deleteSafe((CuratorFramework)this.curator, (String)ZkPath.CLOUD_NODE_IDENTITY.getPath(new String[]{nodeId}));
                    ZooKeeperUtils.deleteSafe((CuratorFramework)this.curator, (String)ZkPath.CLOUD_NODE_CREDENTIAL.getPath(new String[]{nodeId}));
                }
            }
            catch (Exception e) {
                LOGGER.warn("Failed to clear zookeeper jclouds credentials store.", (Throwable)e);
            }
        }

        @Override
        public synchronized Set<String> keySet() {
            HashSet<String> keys = new HashSet();
            try {
                keys = new HashSet(ZooKeeperUtils.getChildren((CuratorFramework)this.curator, (String)ZkPath.CLOUD_NODE.getPath(new String[0])));
            }
            catch (Exception e) {
                LOGGER.warn("Failed to read from zookeeper jclouds credentials store.", (Throwable)e);
                keys = this.cache.asMap().keySet();
            }
            return keys;
        }

        @Override
        public synchronized Collection<Credentials> values() {
            LinkedList<Credentials> credentialsList = new LinkedList<Credentials>();
            for (String key : this.keySet()) {
                credentialsList.add(this.get(key));
            }
            return credentialsList;
        }

        @Override
        public synchronized Set<Map.Entry<String, Credentials>> entrySet() {
            HashSet<Map.Entry<String, Credentials>> entrySet = new HashSet<Map.Entry<String, Credentials>>();
            for (String key : this.keySet()) {
                entrySet.add(new CredentialsEntry(this.curator, key));
            }
            return entrySet;
        }
    }
}

