/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service.jclouds.functions;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import io.fabric8.service.jclouds.CreateJCloudsContainerOptions;
import java.io.File;
import org.jclouds.scriptbuilder.statements.login.AdminAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToAdminAccess {
    private static final Logger LOGGER = LoggerFactory.getLogger(ToAdminAccess.class);

    public static Optional<AdminAccess> apply(CreateJCloudsContainerOptions input) {
        AdminAccess.Builder builder = AdminAccess.builder();
        if (input.isAdminAccess()) {
            if (!Strings.isNullOrEmpty((String)input.getPublicKeyFile())) {
                File publicKey = new File(input.getPublicKeyFile());
                if (publicKey.exists()) {
                    builder.adminPublicKey(publicKey);
                } else {
                    LOGGER.warn("Public key has been specified file: {} files cannot be found. Ignoring.", (Object)publicKey.getAbsolutePath());
                    return Optional.of((Object)AdminAccess.standard());
                }
            }
            if (!Strings.isNullOrEmpty((String)input.getUser())) {
                builder.adminUsername(input.getUser());
            }
            return Optional.of((Object)builder.build());
        }
        return Optional.absent();
    }
}

