/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.boot.commands.support;

import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.Version;
import io.fabric8.boot.commands.support.AbstractCompleterComponent;
import java.util.List;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.completer.StringsCompleter;

@Component(immediate=true)
@Service(value={ProfileCompleter.class, Completer.class})
public final class ProfileCompleter
extends AbstractCompleterComponent {
    @Reference
    protected FabricService fabricService;

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    @Override
    public String getParameter() {
        return "--profile";
    }

    public int complete(String buffer, int cursor, List<String> candidates) {
        StringsCompleter delegate = new StringsCompleter();
        try {
            Version version = this.fabricService.getRequiredDefaultVersion();
            List profiles = version.getProfiles();
            for (Profile profile : profiles) {
                delegate.getStrings().add(profile.getId());
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return delegate.complete(buffer, cursor, candidates);
    }

    public FabricService getFabricService() {
        return this.fabricService;
    }

    public void setFabricService(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    protected void bindFabricService(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    protected void unbindFabricService(FabricService fabricService) {
        if (this.fabricService == fabricService) {
            this.fabricService = null;
        }
    }
}

