/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.osgi.impl;

import java.util.Dictionary;
import org.apache.http.osgi.impl.PropertiesUtils;
import org.apache.http.osgi.services.ProxyConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OSGiProxyConfiguration
implements ProxyConfiguration {
    private static final String PROPERTYNAME_PROXY_ENABLED = "proxy.enabled";
    private static final boolean PROPERTYDEFAULT_PROXY_ENABLED = true;
    private static final String PROPERTYNAME_PROXY_HOSTNAME = "proxy.host";
    private static final String PROPERTYDEFAULT_PROXY_HOSTNAME = "";
    private static final String PROPERTYNAME_PROXY_PORT = "proxy.port";
    private static final int PROPERTYDEFAULT_PROXY_PORT = 0;
    private static final String PROPERTYNAME_PROXY_USERNAME = "proxy.username";
    private static final String PROPERTYDEFAULT_PROXY_USERNAME = "";
    private static final String PROPERTYNAME_PROXY_PASSWORD = "proxy.password";
    private static final String PROPERTYDEFAULT_PROXY_PASSWORD = "";
    private static final String PROPERTYNAME_PROXY_EXCEPTIONS = "proxy.exceptions";
    private static final String[] PROPERTYDEFAULT_PROXY_EXCEPTIONS = new String[]{"localhost", "127.0.0.1"};
    private boolean enabled;
    private String hostname;
    private int port;
    private String username;
    private String password;
    private String[] proxyExceptions;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String[] getProxyExceptions() {
        return this.proxyExceptions;
    }

    public void update(Dictionary<String, Object> config) {
        this.enabled = PropertiesUtils.to(config.get(PROPERTYNAME_PROXY_ENABLED), Boolean.TYPE, true);
        this.hostname = PropertiesUtils.to(config.get(PROPERTYNAME_PROXY_HOSTNAME), String.class, "");
        this.port = PropertiesUtils.to(config.get(PROPERTYNAME_PROXY_PORT), Integer.TYPE, 0);
        this.username = PropertiesUtils.to(config.get(PROPERTYNAME_PROXY_USERNAME), String.class, "");
        this.password = PropertiesUtils.to(config.get(PROPERTYNAME_PROXY_PASSWORD), String.class, "");
        this.proxyExceptions = PropertiesUtils.to(config.get(PROPERTYNAME_PROXY_EXCEPTIONS), String[].class, PROPERTYDEFAULT_PROXY_EXCEPTIONS);
    }

    public String toString() {
        return String.format("ProxyConfiguration [enabled=%s, hostname=%s, port=%s, username=%s, password=%s, proxyExceptions=%s]", this.proxyExceptions, this.enabled, this.hostname, this.port, this.username, this.password, this.proxyExceptions);
    }
}

