/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api.permit;

import io.fabric8.api.permit.PermitKey;
import io.fabric8.api.permit.PermitManager;
import io.fabric8.api.permit.PermitStateTimeoutException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.gravia.utils.IllegalArgumentAssertion;
import org.jboss.gravia.utils.IllegalStateAssertion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultPermitManager
implements PermitManager {
    public static long DEFAULT_TIMEOUT = 60000L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPermitManager.class);
    private final Map<PermitKey<?>, PermitState<?>> permits = new HashMap();

    @Override
    public <T> void activate(PermitKey<T> key, T instance) {
        this.getPermitState(key).activate(instance);
    }

    @Override
    public void deactivate(PermitKey<?> key) {
        this.getPermitState(key).deactivate(DEFAULT_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    @Override
    public void deactivate(PermitKey<?> key, long timeout, TimeUnit unit) {
        this.getPermitState(key).deactivate(timeout, unit);
    }

    @Override
    public <T> PermitManager.Permit<T> aquirePermit(PermitKey<T> key, boolean exclusive) {
        return this.getPermitState(key).acquire(exclusive, DEFAULT_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    @Override
    public <T> PermitManager.Permit<T> aquirePermit(PermitKey<T> key, boolean exclusive, long timeout, TimeUnit unit) {
        return this.getPermitState(key).acquire(exclusive, timeout, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> PermitState<T> getPermitState(PermitKey<T> key) {
        IllegalArgumentAssertion.assertNotNull(key, "key");
        Map<PermitKey<?>, PermitState<?>> map = this.permits;
        synchronized (map) {
            PermitState<Object> permitState = this.permits.get(key);
            if (permitState == null) {
                permitState = new PermitState<T>(key);
                this.permits.put(key, permitState);
            }
            return permitState;
        }
    }

    static class PermitState<T> {
        private final Semaphore semaphore = new Semaphore(0);
        private final ReentrantReadWriteLock rwlock = new ReentrantReadWriteLock(true);
        private final AtomicReference<T> activeInstance = new AtomicReference();
        private final AtomicBoolean exclusiveLock = new AtomicBoolean();
        private final AtomicBoolean active = new AtomicBoolean();
        private final PermitKey<T> key;

        PermitState(PermitKey<T> key) {
            this.key = key;
        }

        void activate(T instance) {
            boolean nowactive = this.active.compareAndSet(false, true);
            IllegalStateAssertion.assertTrue(nowactive, "Cannot activate an already active state");
            LOGGER.debug("activating: {}", (Object)this.key);
            this.activeInstance.set(instance);
            this.semaphore.release(1);
        }

        PermitManager.Permit<T> acquire(final boolean exclusive, long timeout, TimeUnit unit) {
            Lock lock;
            String exclstr;
            String string = exclstr = exclusive ? " exclusive" : "";
            if (LOGGER.isTraceEnabled()) {
                String timestr = unit != null ? " in " + unit.toMillis(timeout) + "ms" : "";
                LOGGER.trace("aquiring" + exclstr + timestr + ": {}", (Object)this.key);
            }
            this.getSinglePermit(timeout, unit);
            final T instance = this.activeInstance.get();
            if (exclusive) {
                lock = this.writeLock(timeout, unit);
                this.exclusiveLock.set(true);
            } else {
                lock = this.readLock(timeout, unit);
                this.semaphore.release(1);
            }
            LOGGER.trace("aquired" + exclstr + ": {}", (Object)this.key);
            return new PermitManager.Permit<T>(){

                @Override
                public PermitKey<T> getPermitKey() {
                    return PermitState.this.key;
                }

                @Override
                public T getInstance() {
                    return instance;
                }

                @Override
                public void release() {
                    LOGGER.trace("releasing" + exclstr + ": {}", (Object)PermitState.this.key);
                    lock.unlock();
                    if (exclusive) {
                        PermitState.this.exclusiveLock.set(false);
                        PermitState.this.semaphore.release(1);
                    }
                }
            };
        }

        void deactivate(long timeout, TimeUnit unit) {
            LOGGER.trace("deactivating: {}", (Object)this.key);
            if (!this.active.get()) {
                LOGGER.trace("not active: {}", (Object)this.key);
                return;
            }
            if (this.exclusiveLock.get()) {
                LOGGER.debug("deactivated (exclusive): {}", (Object)this.key);
                this.active.set(false);
                return;
            }
            this.getSinglePermit(timeout, unit);
            try {
                this.writeLock(timeout, unit).unlock();
                LOGGER.debug("deactivated: {}", (Object)this.key);
                this.active.set(false);
            }
            catch (PermitStateTimeoutException ex) {
                this.semaphore.release(1);
                throw new PermitStateTimeoutException("Cannot deactivate state [" + this.key.getName() + "] in time", this.key, timeout, unit);
            }
        }

        private void getSinglePermit(long timeout, TimeUnit unit) {
            try {
                if (!this.semaphore.tryAcquire(timeout, unit)) {
                    throw new PermitStateTimeoutException("Cannot aquire permit for [" + this.key.getName() + "] in time", this.key, timeout, unit);
                }
            }
            catch (InterruptedException ex) {
                throw new IllegalStateException(ex);
            }
        }

        private ReentrantReadWriteLock.ReadLock readLock(long timeout, TimeUnit unit) {
            ReentrantReadWriteLock.ReadLock lock = this.rwlock.readLock();
            try {
                if (!lock.tryLock() && !lock.tryLock(timeout, unit)) {
                    throw new PermitStateTimeoutException("Cannot aquire read lock for [" + this.key.getName() + "] in time", this.key, timeout, unit);
                }
            }
            catch (InterruptedException ex) {
                throw new IllegalStateException(ex);
            }
            return lock;
        }

        private ReentrantReadWriteLock.WriteLock writeLock(long timeout, TimeUnit unit) {
            ReentrantReadWriteLock.WriteLock lock = this.rwlock.writeLock();
            try {
                if (!lock.tryLock() && !lock.tryLock(timeout, unit)) {
                    throw new PermitStateTimeoutException("Cannot aquire write lock for [" + this.key.getName() + "] in time", this.key, timeout, unit);
                }
            }
            catch (InterruptedException ex) {
                throw new IllegalStateException(ex);
            }
            return lock;
        }
    }
}

