/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class VersionSequence
implements Comparable<VersionSequence> {
    private final String name;
    private final int[] numbers;

    public static Comparator<String> getComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String thisId, String thatId) {
                VersionSequence thisSeq = new VersionSequence(thisId);
                VersionSequence thatSeq = new VersionSequence(thatId);
                return thisSeq.compareTo(thatSeq);
            }
        };
    }

    public VersionSequence(String name) {
        String[] split;
        this.name = name;
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (String text : split = name.split("\\.")) {
            if ((text = text.trim()).length() <= 0) continue;
            try {
                int number = Integer.parseInt(text);
                list.add(number);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        int size = list.size();
        this.numbers = new int[size];
        for (int i = 0; i < size; ++i) {
            this.numbers[i] = (Integer)list.get(i);
        }
    }

    protected VersionSequence(VersionSequence previous) {
        int[] pn = previous.numbers;
        int size = pn.length;
        if (size <= 0) {
            this.numbers = new int[]{1};
        } else {
            this.numbers = Arrays.copyOf(pn, size);
            int n = size - 1;
            this.numbers[n] = this.numbers[n] + 1;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                builder.append(".");
            }
            builder.append(this.numbers[i]);
        }
        this.name = builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionSequence that = (VersionSequence)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        return Arrays.equals(this.numbers, that.numbers);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + Arrays.hashCode(this.numbers);
        return result;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(VersionSequence that) {
        if (this.equals(that)) {
            return 0;
        }
        int[] n1 = this.numbers;
        int[] n2 = that.numbers;
        for (int i = 0; i < n1.length; ++i) {
            if (i >= n2.length) {
                return 1;
            }
            int diff = n1[i] - n2[i];
            if (diff == 0) continue;
            return diff;
        }
        return n1.length - n2.length;
    }

    public String getName() {
        return this.name;
    }

    public int[] getNumbers() {
        return this.numbers;
    }

    public VersionSequence next() {
        return new VersionSequence(this);
    }
}

