/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime.spi;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import org.jboss.gravia.runtime.spi.HeadersProvider;
import org.jboss.gravia.utils.IOUtils;
import org.jboss.gravia.utils.IllegalArgumentAssertion;

public final class PropertiesHeadersProvider
implements HeadersProvider {
    private final Dictionary<String, String> headers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertiesHeadersProvider(File file) throws IOException {
        IllegalArgumentAssertion.assertNotNull(file, "file");
        FileInputStream input = new FileInputStream(file);
        try {
            Properties props = new Properties();
            props.load(input);
            this.headers = this.fromProperties(props);
        }
        finally {
            IOUtils.safeClose(input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertiesHeadersProvider(InputStream input) throws IOException {
        IllegalArgumentAssertion.assertNotNull(input, "input");
        try {
            Properties props = new Properties();
            props.load(input);
            this.headers = this.fromProperties(props);
        }
        finally {
            IOUtils.safeClose(input);
        }
    }

    public PropertiesHeadersProvider(Properties props) {
        this.headers = this.fromProperties(props);
    }

    @Override
    public Dictionary<String, String> getHeaders() {
        return this.headers;
    }

    private Dictionary<String, String> fromProperties(Properties props) {
        Hashtable<String, String> headers = new Hashtable<String, String>();
        IllegalArgumentAssertion.assertNotNull(props, "props");
        for (String key : props.stringPropertyNames()) {
            ((Dictionary)headers).put(key, props.getProperty(key));
        }
        return headers;
    }
}

