/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jolokia.facade;

import io.fabric8.jolokia.facade.facades.FabricServiceFacade;
import io.fabric8.jolokia.facade.mbeans.FabricMBean;
import org.jolokia.client.J4pClient;

public class JolokiaFabricConnector {
    private J4pClient j4p;
    private String userName;
    private String password;
    private String url;
    private FabricServiceFacade fabricServiceFacade;
    private FabricMBean fabricMBeanFacade;

    public static JolokiaFabricConnector getFabricConnector(String user, String password, String url) {
        JolokiaFabricConnector rc = new JolokiaFabricConnector();
        rc.setUserName(user);
        rc.setPassword(password);
        rc.setUrl(url);
        rc.connect();
        return rc;
    }

    public void connect() {
        if (this.j4p != null || this.fabricServiceFacade != null) {
            this.disconnect();
        }
        this.j4p = J4pClient.url(this.url).user(this.userName).password(this.password).build();
        this.fabricServiceFacade = new FabricServiceFacade(this);
        this.fabricMBeanFacade = new FabricMBean(this);
    }

    public void disconnect() {
        if (this.j4p != null) {
            this.j4p = null;
        }
        if (this.fabricServiceFacade != null) {
            this.fabricServiceFacade = null;
        }
        if (this.fabricMBeanFacade != null) {
            this.fabricMBeanFacade = null;
        }
    }

    public FabricServiceFacade getFabricServiceFacade() {
        return this.fabricServiceFacade;
    }

    public FabricMBean getFabricMBeanFacade() {
        return this.fabricMBeanFacade;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public J4pClient getJolokiaClient() {
        return this.j4p;
    }
}

