/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api;

import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.NameValidator;
import io.fabric8.api.Profile;
import io.fabric8.api.jmx.ContainerDTO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Containers {
    private static final transient Logger LOG = LoggerFactory.getLogger(Containers.class);

    public static List<String> containerIds(Container[] containers) {
        ArrayList<String> answer = new ArrayList<String>();
        if (containers != null) {
            for (Container container : containers) {
                answer.add(container.getId());
            }
        }
        Collections.sort(answer);
        return answer;
    }

    public static String containerId(Container container) {
        return container != null ? container.getId() : null;
    }

    public static List<Container> containersForProfile(Container[] containers, String profileId) {
        ArrayList<Container> answer = new ArrayList<Container>();
        if (profileId != null) {
            for (Container c : containers) {
                if (!Containers.containerHasProfile(c, profileId)) continue;
                answer.add(c);
            }
        }
        return answer;
    }

    public static List<Container> containersForProfile(Container[] containers, String profileId, String versionId) {
        ArrayList<Container> answer = new ArrayList<Container>();
        if (profileId != null) {
            for (Container c : containers) {
                String currentId = c.getVersionId();
                if (currentId == null || !currentId.equals(versionId) || !Containers.containerHasProfile(c, profileId)) continue;
                answer.add(c);
            }
        }
        return answer;
    }

    public static NameValidator createNameValidator(Container[] containers) {
        return Containers.createNameValidator(containers, Collections.EMPTY_SET);
    }

    public static NameValidator createNameValidator(Container[] containers, Set<String> ignoreContainerIds) {
        final HashSet<String> ignoreNames = new HashSet<String>(ignoreContainerIds);
        if (containers != null) {
            for (Container container : containers) {
                ignoreNames.add(container.getId());
            }
        }
        return new NameValidator(){

            public String toString() {
                return "NameValidator(notIn: " + ignoreNames + ")";
            }

            @Override
            public boolean isValid(String name) {
                return !ignoreNames.contains(name);
            }
        };
    }

    public static NameValidator joinNameValidators(final NameValidator ... validators) {
        return new NameValidator(){

            public String toString() {
                return "NameValidators:" + Arrays.asList(validators);
            }

            @Override
            public boolean isValid(String name) {
                for (NameValidator validator : validators) {
                    if (validator == null || validator.isValid(name)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static boolean containerHasProfile(Container container, Profile profile) {
        return Containers.containerHasProfile(container, profile.getId());
    }

    public static boolean containerHasProfile(Container container, String profileId) {
        for (Profile p : container.getProfiles()) {
            if (!profileId.equals(p.getId())) continue;
            return true;
        }
        return false;
    }

    public static List<Profile> overlayProfiles(Container container) {
        LinkedHashSet<Profile> set = new LinkedHashSet<Profile>();
        List<Profile> profiles = Arrays.asList(container.getProfiles());
        Containers.recursiveAddProfiles(set, profiles);
        return new ArrayList<Profile>(set);
    }

    protected static void recursiveAddProfiles(Set<Profile> set, List<Profile> profiles) {
        for (Profile profile : profiles) {
            set.add(profile);
            List<Profile> parents = profile.getParents();
            Containers.recursiveAddProfiles(set, parents);
        }
    }

    public static String createContainerName(Container[] containers, String profile, String scheme, NameValidator nameValidator) {
        String name;
        HashMap<String, Container> map = new HashMap<String, Container>();
        for (Container container : containers) {
            map.put(container.getId(), container);
        }
        String namePrefix = profile;
        String postFix = "." + scheme;
        if (namePrefix.endsWith(postFix)) {
            namePrefix = namePrefix.substring(0, namePrefix.length() - postFix.length());
        }
        namePrefix = Containers.filterOutNonAlphaNumerics(namePrefix);
        List<Container> profileContainers = Containers.containersForProfile(containers, profile);
        int idx = profileContainers.size();
        while (map.containsKey(name = namePrefix + Integer.toString(++idx)) || !nameValidator.isValid(name)) {
        }
        return name;
    }

    public static String createUniqueContainerName(Container[] containers, String currentName, NameValidator nameValidator) {
        String name;
        int lastIndex;
        char lastChar;
        if (nameValidator.isValid(currentName)) {
            return currentName;
        }
        String namePrefix = currentName;
        while (namePrefix.length() > 0 && Character.isDigit(lastChar = namePrefix.charAt(lastIndex = namePrefix.length() - 1))) {
            namePrefix = namePrefix.substring(0, lastIndex);
        }
        int idx = 1;
        while (!nameValidator.isValid(name = namePrefix + Integer.toString(++idx))) {
        }
        return name;
    }

    private static String filterOutNonAlphaNumerics(String text) {
        StringBuilder builder = new StringBuilder();
        int size = text.length();
        for (int i = 0; i < size; ++i) {
            char ch = text.charAt(i);
            if (!Character.isLetterOrDigit(ch)) continue;
            builder.append(ch);
        }
        return builder.toString();
    }

    public static List<String> getParentProfileIds(Profile profile) {
        ArrayList<String> answer = new ArrayList<String>();
        List<Profile> parents = profile.getParents();
        for (Profile parent : parents) {
            answer.add(parent.getId());
        }
        return answer;
    }

    public static List<String> rootContainerIds(Container[] containers) {
        ArrayList<String> answer = new ArrayList<String>();
        for (Container container : containers) {
            String id;
            if (!container.isRoot() || answer.contains(id = container.getId())) continue;
            answer.add(id);
        }
        return answer;
    }

    public static List<Container> aliveOrPendingContainersForProfile(String profile, FabricService fabricService) {
        Container[] allContainers = fabricService.getContainers();
        return Containers.aliveOrPendingContainersForProfile(profile, allContainers);
    }

    public static List<Container> aliveOrPendingContainersForProfile(String profile, Container[] allContainers) {
        ArrayList<Container> answer = new ArrayList<Container>();
        List<Container> containers = Containers.containersForProfile(allContainers, profile);
        for (Container container : containers) {
            boolean alive = container.isAlive();
            boolean provisioningPending = container.isProvisioningPending();
            if (!alive && !provisioningPending) continue;
            answer.add(container);
        }
        return answer;
    }

    public static List<Container> aliveAndSuccessfulContainersForProfile(String profile, FabricService fabricService) {
        Container[] allContainers = fabricService.getContainers();
        return Containers.aliveAndSuccessfulContainersForProfile(profile, allContainers);
    }

    public static List<Container> aliveAndSuccessfulContainersForProfile(String profile, Container[] allContainers) {
        ArrayList<Container> answer = new ArrayList<Container>();
        List<Container> containers = Containers.containersForProfile(allContainers, profile);
        for (Container container : containers) {
            boolean aliveAndProvisionSuccess = Containers.isAliveAndProvisionSuccess(container);
            if (!aliveAndProvisionSuccess) continue;
            answer.add(container);
        }
        return answer;
    }

    public static boolean isCurrentContainerAliveAndProvisionSuccess(FabricService service) {
        if (service == null) {
            return false;
        }
        return Containers.isAliveAndProvisionSuccess(service.getCurrentContainer());
    }

    public static boolean isAliveAndProvisionSuccess(Container container) {
        if (container == null) {
            return false;
        }
        boolean alive = container.isAlive();
        boolean provisioningPending = container.isProvisioningPending();
        String provisionResult = container.getProvisionResult();
        return alive && !provisioningPending && "success".equals(provisionResult);
    }

    public static List<ContainerDTO> aliveAndSuccessfulContainers(Iterable<ContainerDTO> allContainers) {
        ArrayList<ContainerDTO> answer = new ArrayList<ContainerDTO>();
        for (ContainerDTO container : allContainers) {
            boolean alive = container.isAlive();
            boolean provisioningPending = container.isProvisioningPending();
            String provisionResult = container.getProvisionResult();
            boolean aliveAndProvisionSuccess = alive && !provisioningPending && "success".equals(provisionResult);
            if (!aliveAndProvisionSuccess) continue;
            answer.add(container);
        }
        return answer;
    }
}

