/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime.spi;

import org.jboss.gravia.runtime.spi.AbstractPropertiesProvider;
import org.jboss.gravia.runtime.spi.PropertiesProvider;
import org.jboss.gravia.runtime.spi.SecurityActions;
import org.jboss.gravia.utils.IllegalArgumentAssertion;

public class EnvPropertiesProvider
extends AbstractPropertiesProvider {
    public static final String ENV_PREFIX_KEY = "environment.prefix";
    public static final String DEFAULT_ENV_PREFIX = "GRAVIA_";
    private static final String ENV_REPLACE_PATTERN = "-|\\.";
    private final String environmentVariablePrefix;

    public EnvPropertiesProvider() {
        this(DEFAULT_ENV_PREFIX);
    }

    public EnvPropertiesProvider(PropertiesProvider source) {
        this(String.valueOf(source.getProperty(ENV_PREFIX_KEY)));
    }

    public EnvPropertiesProvider(String environmentVariablePrefix) {
        IllegalArgumentAssertion.assertNotNull(environmentVariablePrefix, "Environmental variable prefix");
        this.environmentVariablePrefix = environmentVariablePrefix;
    }

    @Override
    public Object getProperty(String key) {
        return this.getProperty(key, null);
    }

    @Override
    public Object getProperty(String key, Object defaultValue) {
        String envVar = SecurityActions.getEnv(EnvPropertiesProvider.toEnvVariable(this.environmentVariablePrefix, key), null);
        return envVar != null ? envVar : defaultValue;
    }

    private static String toEnvVariable(String prefix, String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        return prefix + name.replaceAll(ENV_REPLACE_PATTERN, "_").toUpperCase();
    }
}

