/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime.spi;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.gravia.resource.Attachable;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.ResourceIdentity;
import org.jboss.gravia.resource.Version;
import org.jboss.gravia.resource.VersionRange;
import org.jboss.gravia.resource.spi.AttachableSupport;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.ModuleException;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.spi.AbstractModule;
import org.jboss.gravia.runtime.spi.ModuleEntriesProvider;
import org.jboss.gravia.runtime.spi.PropertiesProvider;
import org.jboss.gravia.runtime.spi.RuntimeEventsManager;
import org.jboss.gravia.runtime.spi.RuntimeLogger;
import org.jboss.gravia.utils.IllegalArgumentAssertion;
import org.jboss.gravia.utils.IllegalStateAssertion;

public abstract class AbstractRuntime
implements Runtime {
    private final ResourceIdentity systemIdentity = ResourceIdentity.create("gravia-system", Version.emptyVersion);
    private final Map<Long, Module> modules = new ConcurrentHashMap<Long, Module>();
    private final CountDownLatch shutdownComplete = new CountDownLatch(1);
    private final AtomicBoolean shutdown = new AtomicBoolean();
    private final RuntimeEventsManager runtimeEvents;
    private final PropertiesProvider properties;

    protected AbstractRuntime(PropertiesProvider propertiesProvider) {
        IllegalArgumentAssertion.assertNotNull(propertiesProvider, "propertiesProvider");
        this.runtimeEvents = new RuntimeEventsManager();
        this.properties = propertiesProvider;
    }

    protected abstract AbstractModule createModule(ClassLoader var1, Resource var2, Dictionary<String, String> var3, Attachable var4);

    protected abstract ModuleEntriesProvider getDefaultEntriesProvider(Module var1, Attachable var2);

    @Override
    public final Object getProperty(String key) {
        return this.properties.getProperty(key);
    }

    @Override
    public Object getRequiredProperty(String propName) {
        Object result = this.properties.getProperty(propName);
        IllegalStateAssertion.assertNotNull(result, "Cannot obtain required property: " + propName);
        return result;
    }

    @Override
    public final Object getProperty(String key, Object defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public <A> A adapt(Class<A> type) {
        Object result = null;
        if (type.isAssignableFrom(RuntimeEventsManager.class)) {
            result = this.runtimeEvents;
        } else if (type.isAssignableFrom(ModuleContext.class)) {
            result = this.getModuleContext();
        }
        return (A)result;
    }

    protected final ResourceIdentity getSystemIdentity() {
        return this.systemIdentity;
    }

    @Override
    public ModuleContext getModuleContext() {
        Module sysmodule = this.getModule(0L);
        return sysmodule != null ? sysmodule.getModuleContext() : null;
    }

    @Override
    public final Module getModule(long id) {
        return this.modules.get(id);
    }

    @Override
    public final Module getModule(ResourceIdentity identity) {
        for (Module module : this.modules.values()) {
            if (!module.getIdentity().equals(identity)) continue;
            return module;
        }
        return null;
    }

    @Override
    public final Module getModule(ClassLoader classLoader) {
        Set<Module> modules = this.getModules(classLoader);
        return modules.size() > 0 ? modules.iterator().next() : null;
    }

    @Override
    public final Set<Module> getModules() {
        return new HashSet<Module>(this.modules.values());
    }

    @Override
    public final Set<Module> getModules(ClassLoader classLoader) {
        Set<Module> result = this.getModules();
        Iterator<Module> iterator = result.iterator();
        while (iterator.hasNext()) {
            Module module = iterator.next();
            if (module.adapt(ClassLoader.class).equals(classLoader)) continue;
            iterator.remove();
        }
        return result;
    }

    @Override
    public Set<Module> getModules(String symbolicName, VersionRange range) {
        Set<Module> result = this.getModules();
        Iterator<Module> iterator = result.iterator();
        while (iterator.hasNext()) {
            ResourceIdentity modid = iterator.next().getIdentity();
            if (symbolicName != null && !symbolicName.equals(modid.getSymbolicName())) {
                iterator.remove();
            }
            if (range == null || range.includes(modid.getVersion())) continue;
            iterator.remove();
        }
        return result;
    }

    @Override
    public final Module installModule(ClassLoader classLoader, Dictionary<String, String> headers) throws ModuleException {
        this.assertNoShutdown();
        return this.installModule(classLoader, null, headers, null);
    }

    @Override
    public final Module installModule(ClassLoader classLoader, Resource resource, Dictionary<String, String> headers) throws ModuleException {
        this.assertNoShutdown();
        return this.installModule(classLoader, resource, headers, null);
    }

    @Override
    public final Module installModule(ClassLoader classLoader, Resource resource, Dictionary<String, String> headers, Attachable context) throws ModuleException {
        this.assertNoShutdown();
        context = context != null ? context : new AttachableSupport();
        AbstractModule module = this.createModule(classLoader, resource, headers, context);
        ModuleEntriesProvider entriesProvider = context.getAttachment(AbstractModule.MODULE_ENTRIES_PROVIDER_KEY);
        ModuleEntriesProvider moduleEntriesProvider = entriesProvider = entriesProvider != null ? entriesProvider : this.getDefaultEntriesProvider(module, context);
        if (entriesProvider != null) {
            module.putAttachment(AbstractModule.MODULE_ENTRIES_PROVIDER_KEY, entriesProvider);
        }
        if (this.getModule(module.getIdentity()) != null) {
            throw new ModuleException("Module already installed: " + module);
        }
        this.modules.put(module.getModuleId(), module);
        module.setState(Module.State.INSTALLED);
        this.runtimeEvents.fireModuleEvent(module, 1);
        RuntimeLogger.LOGGER.info("Installed: {}", (Object)module);
        return module;
    }

    protected void uninstallModule(Module module) {
        this.modules.remove(module.getModuleId());
        RuntimeLogger.LOGGER.info("Uninstalled: {}", (Object)module);
    }

    @Override
    public Runtime shutdown() {
        if (this.shutdown.compareAndSet(false, true)) {
            new ShutdownThread().start();
        }
        return this;
    }

    @Override
    public boolean shutdownInProgress() {
        return this.shutdown.get();
    }

    @Override
    public boolean awaitShutdown(long timeout, TimeUnit unit) throws InterruptedException {
        return this.shutdownComplete.await(timeout, unit);
    }

    @Override
    public boolean shutdownComplete() {
        return this.shutdownComplete.getCount() == 0L;
    }

    protected void assertNoShutdown() {
        if (this.shutdown.get()) {
            throw new IllegalStateException(this.shutdownComplete() ? "Runtime has been shut down" : "Runtime is shuting down");
        }
    }

    protected void doShutdown() {
        for (Module module : this.getModules()) {
            if (module.getIdentity().equals(this.systemIdentity)) continue;
            module.uninstall();
        }
    }

    class ShutdownThread
    extends Thread {
        ShutdownThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                AbstractRuntime.this.doShutdown();
            }
            finally {
                AbstractRuntime.this.shutdownComplete.countDown();
            }
        }
    }
}

