/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime;

import java.util.HashSet;
import java.util.Set;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.RuntimeLocator;
import org.jboss.gravia.utils.IllegalArgumentAssertion;

public enum RuntimeType {
    KARAF,
    TOMCAT,
    WILDFLY,
    OTHER;


    public static RuntimeType getRuntimeType() {
        Runtime runtime = RuntimeLocator.getRequiredRuntime();
        return RuntimeType.getRuntimeType(runtime);
    }

    public static RuntimeType getRuntimeType(Runtime runtime) {
        IllegalArgumentAssertion.assertNotNull(runtime, "runtime");
        Object type = runtime.getProperty("org.jboss.gravia.runtime.type");
        return RuntimeType.getRuntimeType((String)type);
    }

    public static RuntimeType getRuntimeType(String type) {
        String upper = type != null ? type.toUpperCase() : null;
        try {
            return RuntimeType.valueOf(upper);
        }
        catch (RuntimeException ex) {
            return OTHER;
        }
    }

    public static boolean isRuntimeRelevant(String includedTypes, String excludedTypes) {
        return RuntimeType.isRuntimeRelevant(RuntimeType.getRuntimeType(), includedTypes, excludedTypes);
    }

    public static boolean isRuntimeRelevant(RuntimeType runtimeType, String includedTypes, String excludedTypes) {
        boolean result = true;
        if (includedTypes != null || excludedTypes != null) {
            HashSet<RuntimeType> types = new HashSet<RuntimeType>();
            if (includedTypes == null) {
                types.add(runtimeType);
            }
            types.addAll(RuntimeType.getRuntimeTypes(includedTypes));
            types.removeAll(RuntimeType.getRuntimeTypes(excludedTypes));
            result = types.contains((Object)runtimeType);
        }
        return result;
    }

    private static Set<RuntimeType> getRuntimeTypes(String directive) {
        HashSet<RuntimeType> types = new HashSet<RuntimeType>();
        if (directive != null) {
            for (String typespec : directive.split(",\\s*")) {
                types.add(RuntimeType.getRuntimeType(typespec));
            }
        }
        return types;
    }
}

