/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.resource.spi;

import java.util.ArrayList;
import java.util.List;

public final class ElementParser {
    private ElementParser() {
    }

    public static List<String> parseDelimitedString(String value, char delim) {
        return ElementParser.parseDelimitedString(value, delim, true);
    }

    public static List<String> parseDelimitedString(String value, char delim, boolean trim) {
        if (value == null) {
            value = "";
        }
        ArrayList<String> list = new ArrayList<String>();
        int CHAR = 1;
        int DELIMITER = 2;
        int STARTQUOTE = 4;
        int ENDQUOTE = 8;
        StringBuilder sb = new StringBuilder();
        int expecting = CHAR | DELIMITER | STARTQUOTE;
        for (int i = 0; i < value.length(); ++i) {
            boolean isQuote;
            char p = i > 0 ? value.charAt(i - 1) : (char)'\u0000';
            char c = value.charAt(i);
            boolean isDelimiter = delim == c && p != '\\';
            boolean bl = isQuote = (c == '\"' || c == '\'') && p != '\\';
            if (isDelimiter && (expecting & DELIMITER) > 0) {
                ElementParser.addPart(list, sb, trim);
                sb.delete(0, sb.length());
                expecting = CHAR | DELIMITER | STARTQUOTE;
                continue;
            }
            if (isQuote && (expecting & STARTQUOTE) > 0) {
                sb.append(c);
                expecting = CHAR | ENDQUOTE;
                continue;
            }
            if (isQuote && (expecting & ENDQUOTE) > 0) {
                sb.append(c);
                expecting = CHAR | STARTQUOTE | DELIMITER;
                continue;
            }
            if ((expecting & CHAR) > 0) {
                sb.append(c);
                continue;
            }
            throw new IllegalArgumentException("Invalid delimited string [" + value + "] for delimiter: '" + delim + "'");
        }
        if (sb.length() > 0) {
            ElementParser.addPart(list, sb, trim);
        }
        return list;
    }

    private static void addPart(List<String> list, StringBuilder sb, boolean trim) {
        list.add(trim ? sb.toString().trim() : sb.toString());
    }
}

