/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.resource.spi;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.jboss.gravia.resource.ContentCapability;
import org.jboss.gravia.resource.spi.AbstractCapability;
import org.jboss.gravia.resource.spi.AbstractResource;

public class AbstractContentCapability
extends AbstractCapability
implements ContentCapability {
    private String mimeType;
    private String digest;
    private InputStream contentStream;
    private URL contentURL;
    private Long size;

    public AbstractContentCapability(AbstractResource resource, String namespace, Map<String, Object> atts, Map<String, String> dirs) {
        super(resource, namespace, AbstractContentCapability.replaceAttributeTypes(atts), dirs);
        if (this.getAttribute("gravia.content") == null) {
            this.getAttributes().put("gravia.content", "default-digest");
        }
        if (this.getAttribute("mime") == null) {
            this.getAttributes().put("mime", "application/octet-stream");
        }
        if (this.getAttribute("size") == null) {
            this.getAttributes().put("size", ContentCapability.DEFAULT_SIZE);
        }
    }

    private static Map<String, Object> replaceAttributeTypes(Map<String, Object> atts) {
        HashMap<String, Object> result = new HashMap<String, Object>(atts);
        Object val = result.get("size");
        if (val instanceof String) {
            result.put("size", Long.parseLong((String)val));
        }
        if ((val = result.get("url")) instanceof String) {
            result.put("url", AbstractContentCapability.toURL((String)val));
        }
        return result;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public String getDigest() {
        return this.digest;
    }

    @Override
    public InputStream getContentStream() {
        return this.contentStream;
    }

    @Override
    public URL getContentURL() {
        return this.contentURL;
    }

    @Override
    public Long getSize() {
        return this.size;
    }

    @Override
    public void validate() {
        super.validate();
        if ("gravia.content".equals(this.getNamespace())) {
            this.digest = (String)this.getAttribute("gravia.content");
            if (this.digest == null) {
                throw this.illegalStateCannotObtainAttribute("gravia.content");
            }
            this.mimeType = (String)this.getAttribute("mime");
            if (this.mimeType == null) {
                throw this.illegalStateCannotObtainAttribute("mime");
            }
            this.contentURL = (URL)this.getAttribute("url");
            this.contentStream = (InputStream)this.getAttribute("stream");
            if (this.contentURL == null && this.contentStream == null) {
                throw this.illegalStateCannotObtainAttribute("url");
            }
            this.size = (Long)this.getAttribute("size");
            if (this.size == null) {
                throw this.illegalStateCannotObtainAttribute("size");
            }
        }
    }

    private IllegalStateException illegalStateCannotObtainAttribute(String attrName) {
        return new IllegalStateException("Cannot obtain attribute: " + attrName);
    }

    private static URL toURL(String urlspec) {
        try {
            return new URL(urlspec);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(ex);
        }
    }
}

