/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jolokia.facade.utils;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.api.CreateContainerMetadata;
import io.fabric8.api.CreateContainerOptions;
import io.fabric8.api.HasId;
import io.fabric8.jolokia.facade.mbeans.MBeans;
import io.fabric8.jolokia.facade.utils.FieldsToIgnoreForDeserializationMixin;
import io.fabric8.jolokia.facade.utils.FieldsToIgnoreForSerializationMixin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import org.jolokia.client.J4pClient;
import org.jolokia.client.request.J4pExecRequest;
import org.jolokia.client.request.J4pExecResponse;
import org.jolokia.client.request.J4pReadRequest;
import org.jolokia.client.request.J4pReadResponse;
import org.jolokia.client.request.J4pWriteRequest;
import org.jolokia.client.request.J4pWriteResponse;

public class Helpers {
    private static ObjectMapper mapper = null;

    public static List<Object> toList(Object ... args) {
        ArrayList<Object> rc = new ArrayList<Object>();
        for (Object arg : args) {
            rc.add(arg);
        }
        return rc;
    }

    public static J4pExecRequest createExecRequest(String operation, Object ... args) throws MalformedObjectNameException {
        J4pExecRequest rc = new J4pExecRequest(MBeans.FABRIC.getUrl(), operation, args);
        rc.setPreferredHttpMethod("POST");
        return rc;
    }

    public static J4pExecRequest createCustomExecRequest(String mbeanUrl, String operation, Object ... args) throws MalformedObjectNameException {
        J4pExecRequest rc = new J4pExecRequest(mbeanUrl, operation, args);
        rc.setPreferredHttpMethod("POST");
        return rc;
    }

    public static J4pWriteRequest createWriteRequest(String attribute, Object value) throws MalformedObjectNameException {
        J4pWriteRequest answer = new J4pWriteRequest(MBeans.FABRIC.getUrl(), attribute, value, new String[0]);
        answer.setPreferredHttpMethod("POST");
        return answer;
    }

    public static J4pReadRequest createReadRequest(String attribute) throws MalformedObjectNameException {
        J4pReadRequest answer = null;
        answer = attribute == null || attribute.toString().length() < 1 ? new J4pReadRequest(MBeans.FABRIC.getUrl(), new String[0]) : new J4pReadRequest(MBeans.FABRIC.getUrl(), attribute);
        answer.setPreferredHttpMethod("POST");
        return answer;
    }

    public static J4pReadRequest createCustomReadRequest(String mbeanUrl, String attribute) throws MalformedObjectNameException {
        J4pReadRequest answer = null;
        answer = attribute == null || attribute.toString().length() < 1 ? new J4pReadRequest(mbeanUrl, new String[0]) : new J4pReadRequest(mbeanUrl, attribute);
        answer.setPreferredHttpMethod("POST");
        return answer;
    }

    public static void doContainerAction(J4pClient j4p, String action, String id) {
        try {
            J4pExecRequest request = Helpers.createExecRequest(action + "Container(java.lang.String)", id);
            J4pExecResponse response = (J4pExecResponse)j4p.execute(request);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to " + action + " container " + id, e);
        }
    }

    public static <T> T getFieldValue(J4pClient j4p, String operation, String id, String field) {
        T rc = null;
        Map value = (Map)Helpers.exec(j4p, operation, id, Helpers.toList(field));
        rc = (T)value.get(field);
        return rc;
    }

    public static <T> T exec(J4pClient j4p, String operation, Object ... args) {
        try {
            J4pExecRequest request = Helpers.createExecRequest(operation, args);
            J4pExecResponse response = (J4pExecResponse)j4p.execute(request);
            return (T)response.getValue();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to call " + operation + " with args: " + args, e);
        }
    }

    public static String execToJSON(J4pClient j4p, String operation, Object ... args) {
        try {
            J4pExecRequest request = Helpers.createExecRequest(operation, args);
            J4pExecResponse response = (J4pExecResponse)j4p.execute(request);
            return response.getValue().toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to call " + operation + " with args: " + args, e);
        }
    }

    public static String execCustomToJSON(J4pClient j4p, String mbeanUrl, String operation, Object ... args) {
        try {
            J4pExecRequest request = Helpers.createCustomExecRequest(mbeanUrl, operation, args);
            J4pExecResponse response = (J4pExecResponse)j4p.execute(request);
            return response.getValue().toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to call " + operation + " with args: " + args, e);
        }
    }

    public static String readToJSON(J4pClient j4p, String attribute) {
        try {
            J4pReadRequest request = Helpers.createReadRequest(attribute);
            J4pReadResponse response = (J4pReadResponse)j4p.execute(request);
            return response.getValue().toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read " + attribute, e);
        }
    }

    public static String readCustomToJSON(J4pClient j4p, String mbeanUrl, String attribute) {
        try {
            J4pReadRequest request = Helpers.createCustomReadRequest(mbeanUrl, attribute);
            J4pReadResponse response = (J4pReadResponse)j4p.execute(request);
            return response.getValue().toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read " + attribute, e);
        }
    }

    public static <T> T write(J4pClient j4p, String attribute, Object value) {
        try {
            J4pWriteRequest request = Helpers.createWriteRequest(attribute, value);
            J4pWriteResponse response = (J4pWriteResponse)j4p.execute(request);
            return (T)response.getValue();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to write " + attribute + " using new value " + value, e);
        }
    }

    public static <T> T read(J4pClient j4p, String attribute) {
        try {
            J4pReadRequest request = Helpers.createReadRequest(attribute);
            J4pReadResponse response = (J4pReadResponse)j4p.execute(request);
            return (T)response.getValue();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read " + attribute, e);
        }
    }

    public static List<String> extractIds(HasId[] things) {
        return Helpers.extractIds(Arrays.asList(things));
    }

    public static List<String> extractIds(List<HasId> things) {
        ArrayList<String> answer = new ArrayList<String>();
        for (HasId thing : things) {
            answer.add(thing.getId());
        }
        return answer;
    }

    public static ObjectMapper getObjectMapper() {
        if (mapper == null) {
            mapper = new ObjectMapper();
            mapper.addMixInAnnotations(CreateContainerMetadata.class, FieldsToIgnoreForDeserializationMixin.class);
            mapper.addMixInAnnotations(CreateContainerOptions.class, FieldsToIgnoreForDeserializationMixin.class);
            mapper.addMixInAnnotations(CreateContainerOptions.class, FieldsToIgnoreForSerializationMixin.class);
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        }
        return mapper;
    }
}

