/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.api.ChildScalingRequirements;
import io.fabric8.api.DockerScalingRequirements;
import io.fabric8.api.OpenShiftScalingRequirements;
import io.fabric8.api.SshScalingRequirements;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ProfileRequirements
implements Comparable<ProfileRequirements> {
    private String profile;
    private Integer minimumInstances;
    private Integer maximumInstances;
    private List<String> dependentProfiles;
    private ChildScalingRequirements childScalingRequirements;
    private SshScalingRequirements sshScalingRequirements;
    private DockerScalingRequirements dockerScalingRequirements;
    private OpenShiftScalingRequirements openShiftScalingRequirements;
    private Integer maximumInstancesPerHost;

    public ProfileRequirements() {
    }

    public ProfileRequirements(String profile) {
        this.profile = profile;
    }

    public ProfileRequirements(String profile, Integer minimumInstances) {
        this(profile);
        this.minimumInstances = minimumInstances;
    }

    public ProfileRequirements(String profile, Integer minimumInstances, Integer maximumInstances) {
        this(profile, minimumInstances);
        this.maximumInstances = maximumInstances;
    }

    public ProfileRequirements(String profile, Integer minimumInstances, Integer maximumInstances, List<String> dependentProfiles) {
        this(profile, minimumInstances, maximumInstances);
        this.dependentProfiles = dependentProfiles;
    }

    public ProfileRequirements(String profile, Integer minimumInstances, Integer maximumInstances, String ... dependentProfiles) {
        this(profile, minimumInstances, maximumInstances);
        this.dependentProfiles = new ArrayList<String>(Arrays.asList(dependentProfiles));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProfileRequirements that = (ProfileRequirements)o;
        return this.profile.equals(that.profile);
    }

    @Override
    public int compareTo(ProfileRequirements o) {
        return this.profile.compareTo(o.profile);
    }

    public int hashCode() {
        return this.profile.hashCode();
    }

    public String toString() {
        return "ProfileRequirements[" + this.profile + " " + ProfileRequirements.getOrBlank(this.minimumInstances) + ".." + ProfileRequirements.getOrBlank(this.maximumInstances) + "]";
    }

    private static String getOrBlank(Object value) {
        return value != null ? value.toString() : "";
    }

    public void validate() {
        if (this.maximumInstances != null) {
            if (this.maximumInstances < 0) {
                throw new IllegalArgumentException("Maximum instances should be >= 0");
            }
            if (this.minimumInstances != null && this.minimumInstances > this.maximumInstances) {
                throw new IllegalArgumentException("Minimum instances must not be greater than the maximum instances");
            }
        }
        if (this.minimumInstances != null && this.minimumInstances < 0) {
            throw new IllegalArgumentException("Minimum instances should be >= 0");
        }
    }

    public ProfileRequirements dependentProfiles(List<String> profiles) {
        this.setDependentProfiles(profiles);
        return this;
    }

    public ProfileRequirements dependentProfiles(String ... profiles) {
        return this.dependentProfiles(Arrays.asList(profiles));
    }

    public ProfileRequirements minimumInstances(Integer value) {
        this.setMinimumInstances(value);
        return this;
    }

    public ProfileRequirements maximumInstances(Integer value) {
        this.setMaximumInstances(value);
        return this;
    }

    public ChildScalingRequirements childScaling() {
        if (this.childScalingRequirements == null) {
            this.childScalingRequirements = new ChildScalingRequirements();
        }
        return this.getChildScalingRequirements();
    }

    public SshScalingRequirements sshScaling() {
        if (this.sshScalingRequirements == null) {
            this.sshScalingRequirements = new SshScalingRequirements();
        }
        return this.getSshScalingRequirements();
    }

    public DockerScalingRequirements dockerScaling() {
        if (this.dockerScalingRequirements == null) {
            this.dockerScalingRequirements = new DockerScalingRequirements();
        }
        return this.getDockerScalingRequirements();
    }

    public OpenShiftScalingRequirements openShiftScaling() {
        if (this.openShiftScalingRequirements == null) {
            this.openShiftScalingRequirements = new OpenShiftScalingRequirements();
        }
        return this.getOpenShiftScalingRequirements();
    }

    public ProfileRequirements maximumInstancesPerHost(Integer maximumInstancesPerHost) {
        this.maximumInstancesPerHost = maximumInstancesPerHost;
        return this;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public List<String> getDependentProfiles() {
        return this.dependentProfiles;
    }

    public void setDependentProfiles(List<String> dependentProfiles) {
        this.dependentProfiles = dependentProfiles;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getMaximumInstances() {
        return this.maximumInstances;
    }

    public void setMaximumInstances(Integer maximumInstances) {
        this.maximumInstances = maximumInstances;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getMinimumInstances() {
        return this.minimumInstances;
    }

    public void setMinimumInstances(Integer minimumInstances) {
        this.minimumInstances = minimumInstances;
    }

    public ChildScalingRequirements getChildScalingRequirements() {
        return this.childScalingRequirements;
    }

    public void setChildScalingRequirements(ChildScalingRequirements childScalingRequirements) {
        this.childScalingRequirements = childScalingRequirements;
    }

    public SshScalingRequirements getSshScalingRequirements() {
        return this.sshScalingRequirements;
    }

    public void setSshScalingRequirements(SshScalingRequirements sshScalingRequirements) {
        this.sshScalingRequirements = sshScalingRequirements;
    }

    public DockerScalingRequirements getDockerScalingRequirements() {
        return this.dockerScalingRequirements;
    }

    public void setDockerScalingRequirements(DockerScalingRequirements dockerScalingRequirements) {
        this.dockerScalingRequirements = dockerScalingRequirements;
    }

    public OpenShiftScalingRequirements getOpenShiftScalingRequirements() {
        return this.openShiftScalingRequirements;
    }

    public void setOpenShiftScalingRequirements(OpenShiftScalingRequirements openShiftScalingRequirements) {
        this.openShiftScalingRequirements = openShiftScalingRequirements;
    }

    public Integer getMaximumInstancesPerHost() {
        return this.maximumInstancesPerHost;
    }

    public void setMaximumInstancesPerHost(Integer maximumInstancesPerHost) {
        this.maximumInstancesPerHost = maximumInstancesPerHost;
    }

    public double getHealth(int instances) {
        if (instances <= 0) {
            return 0.0;
        }
        if (this.minimumInstances != null) {
            int min = this.minimumInstances;
            if (min <= 0) {
                return 1.0;
            }
            return 1.0 * (double)instances / (double)min;
        }
        return 1.0;
    }

    public boolean checkIsEmpty() {
        return ProfileRequirements.isEmpty(this.minimumInstances) && ProfileRequirements.isEmpty(this.dependentProfiles) && this.maximumInstances == null;
    }

    protected static boolean isEmpty(Integer number) {
        return number == null || number == 0;
    }

    protected static boolean isEmpty(Collection<?> coll) {
        return coll == null || coll.isEmpty();
    }

    public boolean hasMinimumInstances() {
        return this.minimumInstances != null && this.minimumInstances > 0;
    }
}

