/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api;

import io.fabric8.api.AutoScaleProfileStatus;
import io.fabric8.api.AutoScaleStatus;
import io.fabric8.api.FabricRequirements;
import io.fabric8.api.FabricService;
import io.fabric8.api.ProfileRequirements;

public class AutoScaleRequest {
    private final FabricService fabricService;
    private final String version;
    private final String profile;
    private final int delta;
    private final FabricRequirements fabricRequirements;
    private final ProfileRequirements profileRequirements;
    private final AutoScaleStatus status;

    public AutoScaleRequest(FabricService fabricService, String version, String profile, int delta, FabricRequirements fabricRequirements, ProfileRequirements profileRequirements, AutoScaleStatus status) {
        this.fabricService = fabricService;
        this.version = version;
        this.profile = profile;
        this.delta = delta;
        this.fabricRequirements = fabricRequirements;
        this.profileRequirements = profileRequirements;
        this.status = status;
    }

    public FabricService getFabricService() {
        return this.fabricService;
    }

    public String getVersion() {
        return this.version;
    }

    public String getProfile() {
        return this.profile;
    }

    public int getDelta() {
        return this.delta;
    }

    public FabricRequirements getFabricRequirements() {
        return this.fabricRequirements;
    }

    public ProfileRequirements getProfileRequirements() {
        return this.profileRequirements;
    }

    public AutoScaleStatus getStatus() {
        return this.status;
    }

    public AutoScaleProfileStatus getProfileAutoScaleStatus() {
        return this.status.profileStatus(this.profile);
    }
}

