/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api.scr;

import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.scr.AbstractComponent;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.jboss.gravia.utils.IllegalArgumentAssertion;
import org.jboss.gravia.utils.IllegalStateAssertion;

public abstract class AbstractRuntimeProperties
extends AbstractComponent
implements RuntimeProperties {
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private String identity;
    private Path homePath;
    private Path dataPath;
    private Path confPath;

    @Override
    public void activateComponent() {
        this.identity = this.getRequiredProperty("runtime.id");
        this.homePath = Paths.get(this.getRequiredProperty("runtime.home"), new String[0]);
        this.dataPath = Paths.get(this.getRequiredProperty("runtime.data"), new String[0]);
        this.confPath = Paths.get(this.getRequiredProperty("runtime.conf"), new String[0]);
        super.activateComponent();
    }

    @Override
    public void deactivateComponent() {
        super.deactivateComponent();
    }

    @Override
    public String getRuntimeIdentity() {
        return this.identity;
    }

    @Override
    public Path getHomePath() {
        return this.homePath;
    }

    @Override
    public Path getConfPath() {
        return this.confPath;
    }

    @Override
    public Path getDataPath() {
        return this.dataPath;
    }

    @Override
    public String getProperty(String key) {
        return this.getPropertyInternal(key, null);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return this.getPropertyInternal(key, defaultValue);
    }

    protected abstract String getPropertyInternal(String var1, String var2);

    private String getRequiredProperty(String propName) {
        String result = this.getPropertyInternal(propName, null);
        IllegalStateAssertion.assertNotNull((Object)result, (String)("Cannot obtain required property: " + propName));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void putRuntimeAttribute(Class<T> key, T value) {
        IllegalArgumentAssertion.assertNotNull(key, (String)"key");
        IllegalArgumentAssertion.assertNotNull(value, (String)"value");
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            Object exist = this.attributes.get(key.getName());
            IllegalStateAssertion.assertNull((Object)exist, (String)("Runtime already contains attribute: " + exist));
            this.attributes.put(key.getName(), value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getRuntimeAttribute(Class<T> key) {
        IllegalArgumentAssertion.assertNotNull(key, (String)"key");
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            return (T)this.attributes.get(key.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T removeRuntimeAttribute(Class<T> key) {
        IllegalArgumentAssertion.assertNotNull(key, (String)"key");
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            return (T)this.attributes.remove(key.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void clearRuntimeAttributes() {
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            this.attributes.clear();
        }
    }
}

