/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api.scr.support;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ConverterHelper {
    public static final String VALUE_SEPARATOR = ",";
    protected static String[] EMPTY_STRING_ARRAY = new String[0];

    public static Object convertValue(Object value, Type type) throws Exception {
        Class clazz = null;
        Class<?> componentType = Object.class;
        if (type instanceof ParameterizedType) {
            clazz = (Class)((ParameterizedType)type).getRawType();
            componentType = (Class<?>)((ParameterizedType)type).getActualTypeArguments()[0];
        } else if (type instanceof Class) {
            clazz = (Class)type;
        } else {
            throw new IllegalArgumentException();
        }
        if (value != null) {
            String text;
            if (clazz.isInstance(value)) {
                return value;
            }
            if (clazz == String.class) {
                return value.toString();
            }
            if ((clazz == Character.class || clazz == Character.TYPE) && (text = value.toString()).length() > 0) {
                return Character.valueOf(text.charAt(0));
            }
            if (clazz == Boolean.class || clazz == Boolean.TYPE) {
                return ConverterHelper.convertBoolean(value.toString());
            }
            if (clazz == Integer.class || clazz == Integer.TYPE) {
                return ConverterHelper.convertInt(value.toString());
            }
            if (clazz == File.class) {
                return new File(value.toString());
            }
            if (clazz == URI.class) {
                return new URI(value.toString());
            }
            if (clazz == URL.class) {
                return new URL(value.toString());
            }
            text = value.toString();
            if (clazz.isArray()) {
                String[] tokens = ConverterHelper.splitValues(text);
                componentType = clazz.getComponentType();
                Object array = Array.newInstance(componentType, tokens.length);
                int index = 0;
                for (String token : tokens) {
                    Object item = ConverterHelper.convertValue(token, componentType);
                    if (item == null) continue;
                    Array.set(array, index++, item);
                }
                return array;
            }
            if (List.class.isAssignableFrom(clazz)) {
                String[] tokens;
                ArrayList<Object> list = new ArrayList<Object>();
                for (String token : tokens = ConverterHelper.splitValues(text)) {
                    Object item = ConverterHelper.convertValue(token, componentType);
                    list.add(item);
                }
                return list;
            }
            if (Set.class.isAssignableFrom(clazz)) {
                String[] tokens;
                HashSet<Object> set = new HashSet<Object>();
                for (String token : tokens = ConverterHelper.splitValues(text)) {
                    Object item = ConverterHelper.convertValue(token, componentType);
                    set.add(item);
                }
                return set;
            }
            PropertyEditor editor = PropertyEditorManager.findEditor(clazz);
            if (editor != null) {
                editor.setAsText(text);
                return editor.getValue();
            }
        }
        return null;
    }

    private static int convertInt(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static boolean convertBoolean(String value) {
        try {
            return Boolean.parseBoolean(value);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String[] splitValues(String text) {
        String[] split;
        if (text != null && (split = text.split(VALUE_SEPARATOR)) != null) {
            return split;
        }
        return EMPTY_STRING_ARRAY;
    }
}

