/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api.scr.support;

import io.fabric8.api.scr.support.ConverterHelper;
import io.fabric8.api.scr.support.ReflectionHelper;
import java.lang.reflect.Field;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigInjection {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigInjection.class);

    public static <T> void applyConfiguration(Map<String, ?> configuration, T target) throws Exception {
        for (Class<?> clazz = target.getClass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            ConfigInjection.applyConfiguration(configuration, target, clazz);
        }
    }

    private static <T> void applyConfiguration(Map<String, ?> configuration, T target, Class<?> clazz) throws Exception {
        ConfigInjection.injectValues(clazz, target, configuration);
    }

    static void injectValues(Class<?> clazz, Object instance, Map<String, ?> configuration) throws Exception {
        for (Map.Entry<String, ?> entry : configuration.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            try {
                Object convertedValue;
                Field field = clazz.getDeclaredField(ConfigInjection.normalizePropertyName(name));
                if (field == null || (convertedValue = ConverterHelper.convertValue(value, field.getGenericType())) == null) continue;
                ReflectionHelper.setField(field, instance, convertedValue);
            }
            catch (NoSuchFieldException e) {
                LOG.debug("No matching field for property with name {}.", (Object)name);
            }
        }
    }

    static String normalizePropertyName(String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        if (!name.contains(".") && !name.contains("-")) {
            return name;
        }
        String[] parts = name.replaceAll(" ", "").split("-|\\.");
        StringBuilder sb = new StringBuilder();
        if (parts.length > 0) {
            sb.append(parts[0]);
            for (int i = 1; i < parts.length; ++i) {
                String s = parts[i].length() > 0 ? parts[i].substring(0, 1).toUpperCase() + parts[i].substring(1) : "";
                sb.append(s);
            }
        }
        return sb.toString();
    }
}

