/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api;

import io.fabric8.api.Profile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Profiles {
    public static List<String> profileIds(Iterable<Profile> profiles) {
        ArrayList<String> answer = new ArrayList<String>();
        for (Profile profile : profiles) {
            answer.add(profile.getId());
        }
        return answer;
    }

    public static List<String> getConfigurationFileNames(Collection<Profile> profiles) {
        HashSet<String> set = new HashSet<String>();
        for (Profile profile : profiles) {
            set.addAll(profile.getConfigurationFileNames());
        }
        return new ArrayList<String>(set);
    }

    public static byte[] getFileConfiguration(Collection<Profile> profiles, String fileName) {
        Profile profile;
        byte[] answer = null;
        Iterator<Profile> i$ = profiles.iterator();
        while (i$.hasNext() && (answer = (profile = i$.next()).getFileConfiguration(fileName)) == null) {
        }
        return answer;
    }

    public static Map<String, String> getConfigurationFileNameMap(Profile[] profiles) {
        TreeMap<String, String> answer = new TreeMap<String, String>();
        for (Profile profile : profiles) {
            String id = profile.getId();
            List<String> files = profile.getConfigurationFileNames();
            for (String file : files) {
                if (answer.containsKey(file)) continue;
                answer.put(file, id);
            }
        }
        return answer;
    }
}

