/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.fab;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class PomDetails {
    private final File file;
    private final Properties properties;

    public PomDetails(File file, Properties properties) {
        this.file = file;
        this.properties = properties;
    }

    public boolean isValid() {
        return this.file != null && this.properties != null && this.file.exists();
    }

    public String toString() {
        return "PomDetails[" + this.file + "; properties: " + this.properties + "]";
    }

    public File getFile() {
        return this.file;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Model getModel() throws IOException {
        try {
            Model model = new MavenXpp3Reader().read((InputStream)new FileInputStream(this.file));
            model.setGroupId(this.properties.getProperty("groupId", model.getGroupId()));
            model.setArtifactId(this.properties.getProperty("artifactId", model.getArtifactId()));
            model.setVersion(this.properties.getProperty("version", model.getVersion()));
            return model;
        }
        catch (XmlPullParserException e) {
            throw new IOException("Error parsing maven pom " + this.file, e);
        }
    }
}

