/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.fab;

import io.fabric8.fab.Content;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class JarContent
implements Content {
    final JarFile jar;

    public JarContent(JarFile jar) {
        this.jar = jar;
    }

    @Override
    public Iterable<String> getEntries() {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    final Enumeration<JarEntry> enumeration;
                    {
                        this.enumeration = JarContent.this.jar.entries();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.enumeration.hasMoreElements();
                    }

                    @Override
                    public String next() {
                        return this.enumeration.nextElement().getName();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public URL getURL(String entry) throws MalformedURLException {
        ZipEntry je = this.jar.getEntry(entry);
        if (je != null) {
            return new URL("jar:file:" + this.jar.getName() + "!/" + entry);
        }
        return null;
    }

    @Override
    public void close() {
        try {
            this.jar.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toString() {
        return "JarContent[" + this.jar.getName() + ']';
    }
}

