/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.fab;

import io.fabric8.common.util.Strings;
import io.fabric8.fab.VersionedDependencyId;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class ModuleDescriptor {
    public static final String FAB_MODULE_ID = "Id";
    public static final String FAB_MODULE_NAME = "Name";
    public static final String FAB_MODULE_DESCRIPTION = "Description";
    public static final String FAB_MODULE_LONG_DESCRIPTION = "Long-Description";
    public static final String FAB_MODULE_EXTENSION = "Extension";
    public static final String FAB_MODULE_EXTENDS = "Extends";
    public static final String FAB_MODULE_ENDORSED_EXTENSIONS = "Endorsed-Extensions";
    public static final String FAB_MODULE_DEFAULT_EXTENSIONS = "Default-Extensions";
    public static final String FAB_MODULE_SHA1 = "SHA1";
    public static final String[] FAB_MODULE_PROPERTIES = new String[]{"Id", "Name", "Extension", "Description", "Long-Description", "Default-Extensions", "Extends", "Endorsed-Extensions"};
    public String name;
    public String description;
    public String longDescription;
    public VersionedDependencyId id;
    public boolean extensionModule;
    public List<VersionedDependencyId> endorsedExtensions = new ArrayList<VersionedDependencyId>();
    public List<String> defaultExtensions = new ArrayList<String>();
    public List<VersionedDependencyId> extendsModules = new ArrayList<VersionedDependencyId>();

    public List<String> getDefaultExtensions() {
        return this.defaultExtensions;
    }

    public List<VersionedDependencyId> getEndorsedExtensions() {
        return this.endorsedExtensions;
    }

    public List<VersionedDependencyId> getExtendsModules() {
        return this.extendsModules;
    }

    public boolean isExtensionModule() {
        return this.extensionModule;
    }

    public VersionedDependencyId getId() {
        return this.id;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Properties toProperties() {
        Properties rc = new Properties();
        rc.setProperty(FAB_MODULE_ID, this.id.toString());
        rc.setProperty(FAB_MODULE_NAME, Strings.emptyIfNull(this.name));
        rc.setProperty(FAB_MODULE_EXTENSION, "" + this.extensionModule);
        rc.setProperty(FAB_MODULE_DESCRIPTION, Strings.emptyIfNull(this.description));
        rc.setProperty(FAB_MODULE_LONG_DESCRIPTION, Strings.emptyIfNull(this.longDescription));
        rc.setProperty(FAB_MODULE_DEFAULT_EXTENSIONS, Strings.join(this.defaultExtensions, " "));
        rc.setProperty(FAB_MODULE_EXTENDS, Strings.join(this.extendsModules, " "));
        rc.setProperty(FAB_MODULE_ENDORSED_EXTENSIONS, Strings.join(this.endorsedExtensions, " "));
        return rc;
    }

    public static ModuleDescriptor fromProperties(Properties value) {
        ModuleDescriptor rc = new ModuleDescriptor();
        rc.id = VersionedDependencyId.fromString(value.getProperty(FAB_MODULE_ID));
        rc.name = value.getProperty(FAB_MODULE_NAME);
        rc.description = value.getProperty(FAB_MODULE_DESCRIPTION);
        rc.longDescription = value.getProperty(FAB_MODULE_LONG_DESCRIPTION);
        rc.defaultExtensions = Strings.splitAndTrimAsList(value.getProperty(FAB_MODULE_DEFAULT_EXTENSIONS), "\\s+");
        rc.extendsModules = ModuleDescriptor.decodeVersionList(value.getProperty(FAB_MODULE_EXTENDS));
        rc.endorsedExtensions = ModuleDescriptor.decodeVersionList(value.getProperty(FAB_MODULE_ENDORSED_EXTENSIONS));
        rc.extensionModule = Boolean.valueOf(value.getProperty(FAB_MODULE_EXTENSION, "" + !rc.extendsModules.isEmpty()));
        return rc;
    }

    public static List<VersionedDependencyId> decodeVersionList(String property) {
        return ModuleDescriptor.decodeDependencyIds(Strings.splitAndTrimAsList(property, "\\s+"));
    }

    private static List<VersionedDependencyId> decodeDependencyIds(List<String> extensions) {
        ArrayList<VersionedDependencyId> rc = new ArrayList<VersionedDependencyId>(extensions.size());
        for (String extension : extensions) {
            rc.add(VersionedDependencyId.fromString(extension));
        }
        return rc;
    }
}

