/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.fab;

import io.fabric8.common.util.Filter;
import io.fabric8.common.util.Filters;
import io.fabric8.common.util.IOHelpers;
import io.fabric8.common.util.Objects;
import io.fabric8.common.util.Strings;
import io.fabric8.fab.DependencyFilters;
import io.fabric8.fab.DependencyTree;
import io.fabric8.fab.DependencyTreeResult;
import io.fabric8.fab.FailedToResolveDependency;
import io.fabric8.fab.MavenRepositorySystemSession;
import io.fabric8.fab.MavenResolver;
import io.fabric8.fab.PathHelper;
import io.fabric8.fab.PomDetails;
import io.fabric8.fab.ReplaceConflictingVersionResolver;
import io.fabric8.fab.RepositorySystemFactory;
import io.fabric8.fab.VersionedDependencyId;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.RepositoryEvent;
import org.sonatype.aether.RepositoryException;
import org.sonatype.aether.RepositoryListener;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.collection.DependencyCollectionContext;
import org.sonatype.aether.collection.DependencyCollectionException;
import org.sonatype.aether.collection.DependencyGraphTransformationContext;
import org.sonatype.aether.collection.DependencySelector;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.DependencyFilter;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.repository.ArtifactRepository;
import org.sonatype.aether.repository.Authentication;
import org.sonatype.aether.repository.LocalRepository;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.repository.RepositoryPolicy;
import org.sonatype.aether.resolution.ArtifactDescriptorException;
import org.sonatype.aether.resolution.ArtifactDescriptorRequest;
import org.sonatype.aether.resolution.ArtifactDescriptorResult;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.util.artifact.DefaultArtifact;
import org.sonatype.aether.util.filter.AndDependencyFilter;
import org.sonatype.aether.util.graph.DefaultDependencyNode;
import org.sonatype.aether.util.graph.selector.AndDependencySelector;
import org.sonatype.aether.util.graph.selector.ExclusionDependencySelector;
import org.sonatype.aether.util.graph.selector.OptionalDependencySelector;
import org.sonatype.aether.util.graph.selector.ScopeDependencySelector;
import org.sonatype.aether.util.version.GenericVersionScheme;

public class MavenResolverImpl
implements MavenResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenResolverImpl.class);
    private RepositorySystem repositorySystem;
    private String localRepo;
    private String[] repositories = new String[]{"http://repo2.maven.org/maven2", "https://repository.jboss.org/nexus/content/groups/public/", "https://repository.jboss.org/nexus/content/groups/ea/", "http://repository.springsource.com/maven/bundles/release", "http://repository.springsource.com/maven/bundles/external", "http://repository.springsource.com/maven/libraries/release", "http://repository.springsource.com/maven/libraries/external", "https://oss.sonatype.org/content/groups/public", "http://download.java.net/maven/1"};
    private String data;
    private final ThreadLocal<Boolean> installing = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private boolean offline = false;
    private boolean throwExceptionsOnResolveDependencyFailure;
    private static final String DEFAULT_VERSION = "0.0.0";
    private static final Pattern ARTIFACT_MATCHER = Pattern.compile("(.+)(?:-(\\d+)(?:\\.(\\d+)(?:\\.(\\d+))?)?(?:[^a-zA-Z0-9](.*))?)(?:\\.([^\\.]+))", 32);
    private static final Pattern FUZZY_MODIFIDER = Pattern.compile("(?:\\d+[.-])*(.*)", 32);

    public RepositorySystem getRepositorySystem() {
        if (this.repositorySystem == null) {
            try {
                this.repositorySystem = RepositorySystemFactory.newRepositorySystem();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to lazily create RepositorySystem: " + e);
            }
        }
        return this.repositorySystem;
    }

    public void setRepositorySystem(RepositorySystem repositorySystem) {
        this.repositorySystem = repositorySystem;
    }

    public boolean isThrowExceptionsOnResolveDependencyFailure() {
        return this.throwExceptionsOnResolveDependencyFailure;
    }

    public void setThrowExceptionsOnResolveDependencyFailure(boolean throwExceptionsOnResolveDependencyFailure) {
        this.throwExceptionsOnResolveDependencyFailure = throwExceptionsOnResolveDependencyFailure;
    }

    public String getLocalRepo() {
        if (this.localRepo == null) {
            this.localRepo = PathHelper.getUserMavenRepository();
        }
        return this.localRepo;
    }

    public void setLocalRepo(String localRepo) {
        this.localRepo = localRepo;
    }

    public String[] getRepositories() {
        return this.repositories;
    }

    public void setRepositories(String[] repositories) {
        this.repositories = repositories;
    }

    public void setData(String data) {
        this.data = data;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    @Override
    public File resolveFile(Artifact root) throws ArtifactResolutionException {
        RepositorySystem repositorySystem = this.getRepositorySystem();
        MavenRepositorySystemSession session = this.createRepositorSystemSession(this.offline, repositorySystem);
        List<RemoteRepository> repos = this.getRemoteRepositories();
        ArtifactRequest request = new ArtifactRequest();
        request.setArtifact(root);
        request.setRepositories(repos);
        request.setRequestContext("runtime");
        ArtifactResult result = repositorySystem.resolveArtifact((RepositorySystemSession)session, request);
        return result.getArtifact().getFile();
    }

    public List<URL> resolve(File rootPom, boolean offline) throws RepositoryException {
        List<ArtifactResult> results = this.resolveResult(rootPom, offline);
        ArrayList<URL> urls = new ArrayList<URL>();
        for (ArtifactResult r : results) {
            try {
                urls.add(r.getArtifact().getFile().toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return urls;
    }

    public List<ArtifactResult> resolveResult(File rootPom, boolean offline) throws ArtifactDescriptorException, DependencyCollectionException, ArtifactResolutionException {
        RepositorySystem repo = this.getRepositorySystem();
        MavenRepositorySystemSession session = this.createSession(offline, repo);
        List<RemoteRepository> repos = this.getRemoteRepositories();
        Map<String, String> props = Collections.singletonMap("localPath", rootPom.toString());
        DefaultArtifact root = new DefaultArtifact("#groupId", "#artifactId", null, "pom", "#version", props, rootPom);
        ArtifactDescriptorResult artifactDescriptorResult = repo.readArtifactDescriptor((RepositorySystemSession)session, new ArtifactDescriptorRequest((Artifact)root, repos, null));
        CollectRequest request = new CollectRequest(artifactDescriptorResult.getDependencies(), null, repos);
        AndDependencyFilter filter = new AndDependencyFilter(new DependencyFilter[0]);
        return repo.resolveDependencies((RepositorySystemSession)session, request, (DependencyFilter)filter);
    }

    private MavenRepositorySystemSession createSession(boolean offline, RepositorySystem repo) {
        MavenRepositorySystemSession session = new MavenRepositorySystemSession();
        LocalRepository localRepository = new LocalRepository(this.getLocalRepo());
        session.setLocalRepositoryManager(repo.newLocalRepositoryManager(localRepository));
        session.setDependencySelector((DependencySelector)new AndDependencySelector(new DependencySelector[]{new ScopeDependencySelector(new String[]{"test"}), new OptionalDependencySelector(), new ExclusionDependencySelector()}));
        session.setOffline(offline);
        return session;
    }

    public Artifact resolveArtifact(boolean offline, String groupId, String artifactId, String version, String classifier, String extension) throws ArtifactResolutionException {
        RepositorySystem repo = this.getRepositorySystem();
        MavenRepositorySystemSession session = this.createSession(offline, repo);
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, classifier, extension, version);
        List<RemoteRepository> repos = this.getRemoteRepositories();
        ArtifactRequest request = new ArtifactRequest((Artifact)artifact, repos, null);
        ArtifactResult result = repo.resolveArtifact((RepositorySystemSession)session, request);
        return result.getArtifact();
    }

    public DependencyTreeResult collectDependenciesForJar(File jarFile, boolean offline, Filter<Dependency> excludeDependencyFilter) throws RepositoryException, IOException {
        PomDetails pomDetails = this.findPomFile(jarFile);
        if (pomDetails == null || !pomDetails.isValid()) {
            throw new IllegalArgumentException("No pom.xml file could be found inside the jar file: " + jarFile);
        }
        return this.collectDependencies(pomDetails, offline, excludeDependencyFilter);
    }

    @Override
    public DependencyTreeResult collectDependencies(PomDetails pomDetails, boolean offline, Filter<Dependency> excludeDependencyFilter) throws IOException, RepositoryException {
        Model model = pomDetails.getModel();
        return this.collectDependenciesFromPom(pomDetails.getFile(), offline, model, excludeDependencyFilter);
    }

    public DependencyTreeResult collectDependencies(File pomFile, boolean offline) throws RepositoryException, IOException {
        return this.collectDependencies(pomFile, offline, DependencyFilters.testScopeOrOptionalFilter);
    }

    public DependencyTreeResult collectDependencies(File rootPom, boolean offline, Filter<Dependency> excludeDependencyFilter) throws RepositoryException, IOException {
        try {
            Model model = new MavenXpp3Reader().read((InputStream)new FileInputStream(rootPom));
            return this.collectDependenciesFromPom(rootPom, offline, model, excludeDependencyFilter);
        }
        catch (XmlPullParserException e) {
            throw new IOException("Unable to read maven pom " + rootPom, e);
        }
    }

    protected DependencyTreeResult collectDependenciesFromPom(File rootPom, boolean offline, Model model, Filter<Dependency> excludeDependencyFilter) throws RepositoryException, MalformedURLException {
        Map<String, String> props = Collections.singletonMap("localPath", rootPom.toString());
        String groupId = model.getGroupId();
        String artifactId = model.getArtifactId();
        String pomVersion = model.getVersion();
        String packaging = "pom";
        if (groupId == null || artifactId == null || pomVersion == null) {
            throw new IllegalArgumentException("Pomegranate pom.xml has missing groupId:artifactId:version " + groupId + ":" + artifactId + ":" + pomVersion);
        }
        DefaultArtifact root = new DefaultArtifact(groupId, artifactId, null, packaging, pomVersion, props, rootPom);
        return this.collectDependencies((Artifact)root, pomVersion, offline, excludeDependencyFilter);
    }

    @Override
    public DependencyTreeResult collectDependencies(VersionedDependencyId dependencyId, boolean offline, Filter<Dependency> excludeDependencyFilter) throws RepositoryException, IOException {
        return this.collectDependencies(dependencyId.getGroupId(), dependencyId.getArtifactId(), dependencyId.getVersion(), dependencyId.getExtension(), dependencyId.getClassifier(), offline, excludeDependencyFilter);
    }

    public DependencyTreeResult collectDependencies(String groupId, String artifactId, String version, String extension, String classifier, boolean offline, Filter<Dependency> excludeDependencyFilter) throws RepositoryException, IOException {
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, classifier, extension, version);
        return this.collectDependencies((Artifact)artifact, version, offline, excludeDependencyFilter);
    }

    protected DependencyTreeResult collectDependencies(Artifact root, String pomVersion, boolean offline, Filter<Dependency> excludeDependencyFilter) throws RepositoryException, MalformedURLException {
        RepositorySystem repositorySystem = this.getRepositorySystem();
        final MavenRepositorySystemSession session = this.createRepositorSystemSession(offline, repositorySystem);
        List<RemoteRepository> repos = this.getRemoteRepositories();
        ArtifactDescriptorResult artifactDescriptorResult = repositorySystem.readArtifactDescriptor((RepositorySystemSession)session, new ArtifactDescriptorRequest(root, repos, null));
        repos.addAll(artifactDescriptorResult.getRepositories());
        Dependency rootDependency = new Dependency(root, null);
        List dependencies = artifactDescriptorResult.getDependencies();
        DefaultDependencyNode rootNode = new DefaultDependencyNode(rootDependency);
        GenericVersionScheme versionScheme = new GenericVersionScheme();
        rootNode.setVersion(versionScheme.parseVersion(pomVersion));
        rootNode.setVersionConstraint(versionScheme.parseVersionConstraint(pomVersion));
        DefaultDependencyNode pomNode = rootNode;
        final Filter<Dependency> shouldExclude = Filters.or(DependencyFilters.testScopeFilter, excludeDependencyFilter);
        AndDependencySelector dependencySelector = new AndDependencySelector(new DependencySelector[]{new ScopeDependencySelector(new String[]{"test"}), new ExclusionDependencySelector(), new DependencySelector(){

            public DependencySelector deriveChildSelector(DependencyCollectionContext context) {
                return this;
            }

            public boolean selectDependency(Dependency dependency) {
                try {
                    boolean answer = DependencyFilters.matches(dependency, (Filter<Dependency>)shouldExclude);
                    return !answer;
                }
                catch (Exception e) {
                    MavenResolverImpl.this.failedToMakeDependencyTree(dependency, e);
                    return false;
                }
            }
        }});
        session.setDependencySelector((DependencySelector)dependencySelector);
        for (Dependency dependency : dependencies) {
            DependencyNode node = this.resolveDepedencies(repositorySystem, session, repos, (DependencyNode)pomNode, dependency, shouldExclude);
            if (node == null) continue;
            pomNode.getChildren().add(node);
        }
        DependencyGraphTransformationContext tranformContext = new DependencyGraphTransformationContext(){
            Map map = new HashMap();

            public RepositorySystemSession getSession() {
                return session;
            }

            public Object get(Object key) {
                return this.map.get(key);
            }

            public Object put(Object key, Object value) {
                return this.map.put(key, value);
            }
        };
        ReplaceConflictingVersionResolver transformer = new ReplaceConflictingVersionResolver();
        pomNode = transformer.transformGraph((DependencyNode)pomNode, tranformContext);
        DependencyTreeResult result = new DependencyTreeResult((DependencyNode)pomNode, this, excludeDependencyFilter);
        List<DependencyTree.DuplicateDependency> duplicates = result.getTree().checkForDuplicateDependencies();
        for (DependencyTree.DuplicateDependency duplicate : duplicates) {
            LOGGER.warn("Duplicate dependency: " + duplicate);
        }
        return result;
    }

    protected DependencyNode resolveDepedencies(RepositorySystem repositorySystem, MavenRepositorySystemSession session, List<RemoteRepository> repos, DependencyNode pomNode, Dependency dependency, final Filter<Dependency> shouldExclude) throws FailedToResolveDependency {
        if (!DependencyFilters.matches(dependency, shouldExclude)) {
            CollectRequest request = new CollectRequest(dependency, repos);
            try {
                DependencyNode node = repositorySystem.collectDependencies((RepositorySystemSession)session, request).getRoot();
                repositorySystem.resolveDependencies((RepositorySystemSession)session, node, new DependencyFilter(){

                    public boolean accept(DependencyNode node, List<DependencyNode> parents) {
                        boolean answer = !DependencyFilters.matches(node, (Filter<Dependency>)shouldExclude);
                        return answer;
                    }
                });
                return node;
            }
            catch (DependencyCollectionException e) {
                this.handleDependencyResolveFailure(pomNode, dependency, (Exception)((Object)e));
            }
            catch (ArtifactResolutionException e) {
                this.handleDependencyResolveFailure(pomNode, dependency, (Exception)((Object)e));
            }
        }
        return null;
    }

    protected void failedToMakeDependencyTree(Object dependency, Exception e) {
        LOGGER.warn("Failed to make Dependency for " + dependency + ". " + e, (Throwable)e);
    }

    protected void handleDependencyResolveFailure(DependencyNode pomNode, Dependency dependency, Exception e) throws FailedToResolveDependency {
        FailedToResolveDependency exception = new FailedToResolveDependency(dependency, e);
        if (this.throwExceptionsOnResolveDependencyFailure) {
            throw exception;
        }
        LOGGER.warn(exception.getMessage(), (Throwable)e);
        DefaultDependencyNode node = new DefaultDependencyNode(dependency);
        pomNode.getChildren().add(node);
    }

    protected MavenRepositorySystemSession createRepositorSystemSession(boolean offline, RepositorySystem repo) {
        MavenRepositorySystemSession session = new MavenRepositorySystemSession();
        LocalRepository localRepository = new LocalRepository(this.getLocalRepo());
        session.setLocalRepositoryManager(repo.newLocalRepositoryManager(localRepository));
        session.setDependencySelector((DependencySelector)new AndDependencySelector(new DependencySelector[]{new ScopeDependencySelector(new String[]{"test"}), new ExclusionDependencySelector()}));
        session.setOffline(offline);
        session.setRepositoryListener(new RepositoryListener(){

            public void artifactDescriptorInvalid(RepositoryEvent event) {
                this.logException("Invalid artifact descriptor: ", event);
            }

            public void artifactDescriptorMissing(RepositoryEvent event) {
                this.logException("Missing artifact descriptor: ", event);
            }

            public void metadataInvalid(RepositoryEvent event) {
                this.logException("Invalid metadata: ", event);
            }

            public void artifactResolving(RepositoryEvent event) {
                LOGGER.debug("Resolving artifact: " + this.toString(event));
            }

            public void artifactResolved(RepositoryEvent event) {
                LOGGER.debug("Resolved artifact: " + this.toString(event));
            }

            public void metadataResolving(RepositoryEvent event) {
                LOGGER.debug("Metadata resolving: " + this.toString(event));
            }

            public void metadataResolved(RepositoryEvent event) {
                LOGGER.debug("Metadata resolved: " + this.toString(event));
            }

            public void artifactDownloading(RepositoryEvent event) {
                LOGGER.debug("Artifact downloading: " + this.toString(event));
            }

            public void artifactDownloaded(RepositoryEvent event) {
                LOGGER.debug("Metadata downloaded: " + this.toString(event));
            }

            public void metadataDownloading(RepositoryEvent event) {
                LOGGER.debug("Metadata downloading: " + this.toString(event));
            }

            public void metadataDownloaded(RepositoryEvent event) {
                LOGGER.debug("Metadata downloaded: " + this.toString(event));
            }

            public void artifactInstalling(RepositoryEvent event) {
                LOGGER.debug("Artifact installing: " + this.toString(event));
            }

            public void artifactInstalled(RepositoryEvent event) {
                LOGGER.debug("Artifact installed: " + this.toString(event));
            }

            public void metadataInstalling(RepositoryEvent event) {
                LOGGER.debug("Metadata installing: " + this.toString(event));
            }

            public void metadataInstalled(RepositoryEvent event) {
                LOGGER.debug("Metadata installed: " + this.toString(event));
            }

            public void artifactDeploying(RepositoryEvent event) {
                LOGGER.debug("Artifact deploying: " + this.toString(event));
            }

            public void artifactDeployed(RepositoryEvent event) {
                LOGGER.debug("Artifact deployed: " + this.toString(event));
            }

            public void metadataDeploying(RepositoryEvent event) {
                LOGGER.debug("Metadata deploying: " + this.toString(event));
            }

            public void metadataDeployed(RepositoryEvent event) {
                LOGGER.debug("Metadata deployed: " + this.toString(event));
            }

            protected void logException(String message, RepositoryEvent event) {
                Exception exception = event.getException();
                List exceptions = event.getExceptions();
                String text = message + this.toString(event);
                if (exceptions.isEmpty()) {
                    LOGGER.warn(text + " " + exception, (Throwable)exception);
                } else if (exception != null) {
                    LOGGER.warn(text + " " + exceptions, (Throwable)exception);
                }
            }

            protected String toString(RepositoryEvent event) {
                Artifact value = event.getArtifact();
                if (value == null) {
                    value = event.getMetadata();
                }
                ArtifactRepository repository = event.getRepository();
                String text = "" + value;
                if (repository != null) {
                    return text + " on " + repository;
                }
                return text;
            }
        });
        return session;
    }

    protected List<RemoteRepository> getRemoteRepositories() {
        ArrayList<RemoteRepository> repos = new ArrayList<RemoteRepository>();
        for (int i = 0; i < this.repositories.length; ++i) {
            int idx;
            String text = this.repositories[i].trim();
            Authentication authentication = this.getAuthentication(text);
            if (authentication != null) {
                text = text.replaceFirst(String.format("%s:%s@", authentication.getUsername(), authentication.getPassword()), "");
            }
            boolean snapshot = false;
            while ((idx = text.lastIndexOf(64)) > 0) {
                String postfix = text.substring(idx + 1);
                if (postfix.equals("snapshots")) {
                    snapshot = true;
                } else if (!postfix.equals("noreleases") && !postfix.startsWith("id")) {
                    LOGGER.warn("Unknown postfix: @" + postfix + " on repository URL: " + text);
                    break;
                }
                text = text.substring(0, idx);
            }
            RemoteRepository repository = new RemoteRepository("repos" + i, "default", text);
            RepositoryPolicy policy = new RepositoryPolicy(true, "daily", "warn");
            repository.setPolicy(snapshot, policy);
            repository.setAuthentication(authentication);
            repos.add(repository);
        }
        return repos;
    }

    private Authentication getAuthentication(String text) {
        Authentication authentication = null;
        try {
            String[] parts;
            URL url = new URL(text);
            String authority = url.getUserInfo();
            if (Strings.notEmpty(authority) && (parts = authority.split(":")).length == 2) {
                authentication = new Authentication(parts[0], parts[1]);
            }
        }
        catch (MalformedURLException e) {
            LOGGER.warn("{} does not look like a valid repository URL");
        }
        return authentication;
    }

    @Override
    public PomDetails findPomFile(File jar) throws IOException {
        JarFile jarFile = new JarFile(jar);
        File file = null;
        Properties properties = null;
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            InputStream in;
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (name.matches("META-INF/maven/.*/.*/pom.xml")) {
                in = jarFile.getInputStream(entry);
                file = File.createTempFile("fabric-pomegranate-", ".pom.xml");
                IOHelpers.writeTo(file, in);
            } else if (name.matches("META-INF/maven/.*/.*/pom.properties")) {
                in = jarFile.getInputStream(entry);
                properties = new Properties();
                properties.load(in);
            }
            if (file == null || properties == null) continue;
            break;
        }
        return new PomDetails(file, properties);
    }

    private static String getName(String location) {
        int idx = location.lastIndexOf(58);
        if (idx < 0) {
            idx = 0;
        }
        if ((idx = location.lastIndexOf(47, idx)) >= 0) {
            return location.substring(idx + 1);
        }
        return location;
    }

    public static String[] extractNameVersionType(String url) {
        Matcher m = ARTIFACT_MATCHER.matcher(url);
        if (!m.matches()) {
            return new String[]{url, DEFAULT_VERSION};
        }
        StringBuffer v = new StringBuffer();
        String d1 = m.group(1);
        String d2 = m.group(2);
        String d3 = m.group(3);
        String d4 = m.group(4);
        String d5 = m.group(5);
        String d6 = m.group(6);
        if (d2 != null) {
            v.append(d2);
            if (d3 != null) {
                v.append('.');
                v.append(d3);
                if (d4 != null) {
                    v.append('.');
                    v.append(d4);
                    if (d5 != null) {
                        v.append(".");
                        MavenResolverImpl.cleanupModifier(v, d5);
                    }
                } else if (d5 != null) {
                    v.append(".0.");
                    MavenResolverImpl.cleanupModifier(v, d5);
                }
            } else if (d5 != null) {
                v.append(".0.0.");
                MavenResolverImpl.cleanupModifier(v, d5);
            }
        }
        return new String[]{d1, v.toString(), d6};
    }

    private static void cleanupModifier(StringBuffer result, String modifier) {
        Matcher m = FUZZY_MODIFIDER.matcher(modifier);
        if (m.matches()) {
            modifier = m.group(1);
        }
        for (int i = 0; i < modifier.length(); ++i) {
            char c = modifier.charAt(i);
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_') && c != '-') continue;
            result.append(c);
        }
    }

    private static class NewerVersionExistsFilter
    implements Filter<Dependency> {
        private final DefaultDependencyNode rootNode;

        public NewerVersionExistsFilter(DefaultDependencyNode rootNode) {
            this.rootNode = rootNode;
        }

        @Override
        public boolean matches(Dependency dependency) {
            return this.newerVersionExists((DependencyNode)this.rootNode, dependency);
        }

        public boolean newerVersionExists(DependencyNode node, Dependency dependency) {
            if (this.isNewer(node.getDependency(), dependency)) {
                return true;
            }
            List children = node.getChildren();
            for (DependencyNode child : children) {
                if (!this.newerVersionExists(child, dependency)) continue;
                return true;
            }
            return false;
        }

        private boolean isNewer(Dependency dep1, Dependency dep2) {
            return this.isNewer(dep1.getArtifact(), dep2.getArtifact());
        }

        private boolean isNewer(Artifact a1, Artifact a2) {
            String v2;
            String v1;
            if (Objects.equal(a1.getGroupId(), a2.getGroupId()) && Objects.equal(a1.getArtifactId(), a2.getArtifactId()) && Objects.equal(a1.getExtension(), a2.getExtension()) && Objects.equal(a1.getClassifier(), a2.getClassifier()) && !Objects.equal(v1 = a1.getVersion(), v2 = a2.getVersion())) {
                int c = v1.compareTo(v2);
                return c > 0;
            }
            return false;
        }
    }
}

