/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.common.util;

import io.fabric8.common.util.IOHelpers;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedHashSet;

public class Files {
    private static final ThreadLocal<LinkedHashSet<URL>> ACTIVE_DOWNLOADS = new ThreadLocal();

    public static int recursiveDelete(File file) {
        File[] files;
        int answer = 0;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File child : files) {
                answer += Files.recursiveDelete(child);
            }
        }
        if (file.delete()) {
            ++answer;
        }
        return answer;
    }

    public static File urlToFile(String url, String tempFilePrefix, String tempFilePostfix) throws IOException {
        File file = new File(url);
        if (file.exists()) {
            return file;
        }
        return Files.urlToFile(new URL(url), tempFilePrefix, tempFilePostfix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File urlToFile(URL url, String tempFilePrefix, String tempFilePostfix) throws IOException {
        LinkedHashSet<URL> original = ACTIVE_DOWNLOADS.get();
        LinkedHashSet<URL> downloads = original;
        if (downloads == null) {
            downloads = new LinkedHashSet();
            ACTIVE_DOWNLOADS.set(downloads);
        }
        try {
            File file;
            if (downloads.contains(url)) {
                throw new DownloadCycle("Download cycle detected: " + downloads);
            }
            downloads.add(url);
            try {
                String fileName = url.getFile();
                File file2 = new File(fileName);
                if (!file2.exists()) {
                    file2 = File.createTempFile(tempFilePrefix, tempFilePostfix);
                    InputStream in = url.openStream();
                    IOHelpers.writeTo(file2, in);
                }
                file = file2;
            }
            catch (Throwable throwable) {
                downloads.remove(url);
                throw throwable;
            }
            downloads.remove(url);
            return file;
        }
        finally {
            if (original == null) {
                ACTIVE_DOWNLOADS.remove();
            }
        }
    }

    public static class DownloadCycle
    extends IOException {
        public DownloadCycle(String s) {
            super(s);
        }
    }
}

