/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.etcd.impl.dsl;

import io.fabric8.etcd.api.Keys;
import io.fabric8.etcd.api.Response;
import io.fabric8.etcd.core.AsynchronousExecution;
import io.fabric8.etcd.core.Operation;
import io.fabric8.etcd.core.OperationContext;
import io.fabric8.etcd.core.SynchronousExecution;
import io.fabric8.etcd.dsl.AsyncGetDataBuilder;
import io.fabric8.etcd.dsl.GetDataBuilder;
import java.util.concurrent.Future;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;

public class GetDataImpl
implements Operation {
    private final String key;
    private final boolean recursive;
    private final boolean sorted;
    private final boolean shouldWait;
    private final int waitIndex;

    public GetDataImpl(String key, boolean recursive, boolean sorted, boolean shouldWait, int waitIndex) {
        this.key = key;
        this.recursive = recursive;
        this.sorted = sorted;
        this.shouldWait = shouldWait;
        this.waitIndex = waitIndex;
    }

    @Override
    public HttpUriRequest createRequest(OperationContext context) {
        try {
            URIBuilder builder = new URIBuilder(context.getBaseUri()).setPath(Keys.makeKey((String)this.key)).addParameter("recursive", String.valueOf(this.recursive)).addParameter("sorted", String.valueOf(this.sorted));
            if (this.shouldWait) {
                builder = builder.addParameter("wait", "true");
                if (this.waitIndex > 0) {
                    builder = builder.addParameter("waitIndex", String.valueOf(this.waitIndex));
                }
            }
            return new HttpGet(builder.build());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class AsyncBuilder
    implements AsyncGetDataBuilder {
        private final OperationContext context;
        private final AsynchronousExecution execution = new AsynchronousExecution();
        private boolean recursive;
        private boolean sorted;
        private int waitIndex;

        public AsyncBuilder(OperationContext context, Builder builder) {
            this.context = context;
            this.recursive = builder.recursive;
            this.sorted = builder.sorted;
            this.waitIndex = builder.waitIndex;
        }

        public Future<Response> forKey(String key) {
            return this.execution.execute(this.context, new GetDataImpl(key, this.recursive, this.sorted, true, this.waitIndex));
        }

        public AsyncBuilder recursive() {
            this.recursive = true;
            return this;
        }

        public AsyncBuilder sorted() {
            this.sorted = true;
            return this;
        }
    }

    public static class Builder
    implements GetDataBuilder {
        private final SynchronousExecution execution = new SynchronousExecution();
        private final OperationContext context;
        private boolean recursive;
        private boolean sorted;
        private int waitIndex;

        public Builder(OperationContext context) {
            this.context = context;
        }

        public Response forKey(String key) {
            return this.execution.execute(this.context, new GetDataImpl(key, this.recursive, this.sorted, false, 0));
        }

        public Builder recursive() {
            this.recursive = true;
            return this;
        }

        public Builder sorted() {
            this.sorted = true;
            return this;
        }

        public AsyncGetDataBuilder waitIndex(int waitIndex) {
            this.waitIndex = waitIndex;
            return new AsyncBuilder(this.context, this);
        }

        public AsyncGetDataBuilder watch() {
            return new AsyncBuilder(this.context, this);
        }
    }
}

